function clientPacketRedirectTransform(methodNode, methodInsnNode){
	var Opcodes=Java.type('org.objectweb.asm.Opcodes')
	var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
	var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
	var instructions = methodNode.instructions
	var patchList = new InsnList()
	patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
	//INVOKESTATIC xaero/common/core/LaunchPlugin.chunkUpdateCallback (Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$ChunkRender;)V
	patchList.add(methodInsnNode)
	instructions.insertBefore(instructions.getFirst(), patchList)
}

function initializeCoreMod() {
	return {
		'xaero_chunkclass': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.world.chunk.Chunk'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
                var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode')
                var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				fields.add(new FieldNode(Opcodes.ACC_PUBLIC, "xaero_chunkDirty", "Z", null, true))
				return classNode
			}
		},
		'xaero_clientplaynethandler_handleblockchange': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_147234_a',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SChangeBlockPacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onBlockChange", "(Lnet/minecraft/network/play/server/SChangeBlockPacket;)V"))
				return methodNode
			}
		},
		'xaero_clientplaynethandler_handlemultiblockchange': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_147287_a',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SMultiBlockChangePacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onMultiBlockChange", "(Lnet/minecraft/network/play/server/SMultiBlockChangePacket;)V"))
				return methodNode
			}
		},
		'xaero_clientplaynethandler_handlechunkdata': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_147263_a',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SChunkDataPacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onChunkData", "(Lnet/minecraft/network/play/server/SChunkDataPacket;)V"))
				return methodNode
			}
		}
	}
}