/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.tileentity.TackleBoxTileEntity;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.model.TackleBoxModel;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class TackleBoxRenderer<T extends TackleBoxTileEntity>
extends TileEntityRenderer<T> {
    private static final ResourceLocation TACKLE_BOX_TEXTURE = new ResourceLocation("aquaculture", "textures/entity/tileentity/tackle_box.png");
    private final TackleBoxModel tackleBoxModel = new TackleBoxModel();

    public void render(T tackleBox, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState tackleBoxSouth;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState blockState = tackleBoxSouth = tackleBox.func_145830_o() ? tackleBox.func_195044_w() : (BlockState)AquaBlocks.TACKLE_BOX.func_176223_P().func_206870_a((IProperty)TackleBoxBlock.FACING, (Comparable)Direction.SOUTH);
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.5f, (float)4.5f, (float)4.0f);
            GlStateManager.translatef((float)0.0325f, (float)0.0325f, (float)0.0325f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.func_147499_a(TACKLE_BOX_TEXTURE);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 1.15f), (float)((float)z));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.scalef((float)0.065f, (float)0.065f, (float)0.065f);
        Direction direction = (Direction)tackleBoxSouth.func_177229_b((IProperty)TackleBoxBlock.FACING);
        if ((double)Math.abs(direction.func_185119_l()) > 1.0E-5) {
            GlStateManager.rotatef((float)direction.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (direction == Direction.NORTH) {
            GlStateManager.translatef((float)-14.65f, (float)0.0f, (float)7.75f);
        } else if (direction == Direction.SOUTH) {
            GlStateManager.translatef((float)0.65f, (float)0.0f, (float)-7.75f);
        } else if (direction == Direction.WEST) {
            GlStateManager.translatef((float)0.65f, (float)0.0f, (float)7.75f);
        } else if (direction == Direction.EAST) {
            GlStateManager.translatef((float)-14.65f, (float)0.0f, (float)-7.75f);
        }
        this.applyLidRotation(tackleBox, partialTicks, this.tackleBoxModel);
        this.tackleBoxModel.render(1.0f);
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void applyLidRotation(T tackleBox, float partialTicks, TackleBoxModel tackleBoxModel) {
        float lidAngle = ((TackleBoxTileEntity)((Object)tackleBox)).func_195480_a(partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        tackleBoxModel.getLid().field_78795_f = -(lidAngle * 1.5707964f);
    }
}

