/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCatchfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class AquaFishRenderer
extends MobRenderer<AquaFishEntity, EntityModel<AquaFishEntity>> {
    private static final TropicalFishBModel<AquaFishEntity> TROPICAL_FISH_B_MODEL = new TropicalFishBModel();
    private static final FishSmallModel<AquaFishEntity> SMALL_MODEL = new FishSmallModel();
    private static final FishMediumModel<AquaFishEntity> MEDIUM_MODEL = new FishMediumModel();
    private static final FishLargeModel<AquaFishEntity> LARGE_MODEL = new FishLargeModel();
    private static final FishLongnoseModel<AquaFishEntity> LONGNOSE_MODEL = new FishLongnoseModel();
    private static final FishCatchfishModel<AquaFishEntity> CATFISH_MODEL = new FishCatchfishModel();
    private static final JellyfishModel<AquaFishEntity> JELLYFISH_MODEL = new JellyfishModel();

    public AquaFishRenderer(EntityRendererManager manager) {
        super(manager, MEDIUM_MODEL, 0.35f);
    }

    public void doRender(@Nonnull AquaFishEntity fishEntity, double x, double y, double z, float entityYaw, float partialTicks) {
        switch (AquaFishEntity.TYPES.get(fishEntity.func_200600_R())) {
            case SMALL: {
                this.field_77045_g = SMALL_MODEL;
                break;
            }
            case LARGE: {
                this.field_77045_g = LARGE_MODEL;
                break;
            }
            case LONGNOSE: {
                this.field_77045_g = LONGNOSE_MODEL;
                break;
            }
            case CATFISH: {
                this.field_77045_g = CATFISH_MODEL;
                break;
            }
            case JELLYFISH: {
                this.field_77045_g = JELLYFISH_MODEL;
                break;
            }
            case HALIBUT: {
                this.field_77045_g = TROPICAL_FISH_B_MODEL;
                break;
            }
            default: {
                this.field_77045_g = MEDIUM_MODEL;
            }
        }
        super.func_76986_a((MobEntity)fishEntity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull AquaFishEntity fishEntity) {
        ResourceLocation location = fishEntity.func_200600_R().getRegistryName();
        if (location != null) {
            return new ResourceLocation("aquaculture", "textures/entity/fish/" + location.func_110623_a() + ".png");
        }
        return null;
    }

    protected void applyRotations(AquaFishEntity fishEntity, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((LivingEntity)fishEntity, ageInTicks, rotationYaw, partialTicks);
        FishType fishType = AquaFishEntity.TYPES.get(fishEntity.func_200600_R());
        if (fishType != FishType.JELLYFISH) {
            float salmonRotation = 1.0f;
            float salmonMultiplier = 1.0f;
            if (fishType == FishType.LONGNOSE && !fishEntity.func_70090_H()) {
                salmonRotation = 1.3f;
                salmonMultiplier = 1.7f;
            }
            float fishRotation = fishType == FishType.LONGNOSE ? salmonRotation * 4.3f * MathHelper.func_76126_a((float)(salmonMultiplier * 0.6f * ageInTicks)) : 4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
            GlStateManager.rotatef((float)fishRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            if (fishType == FishType.LONGNOSE) {
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-0.4f);
            }
            if (!fishEntity.func_70090_H() && fishType != FishType.HALIBUT) {
                if (fishType == FishType.MEDIUM || fishType == FishType.LARGE || fishType == FishType.CATFISH) {
                    GlStateManager.translatef((float)0.1f, (float)0.1f, (float)-0.1f);
                } else {
                    GlStateManager.translatef((float)0.2f, (float)0.1f, (float)0.0f);
                }
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (fishType == FishType.HALIBUT) {
                GlStateManager.translatef((float)-0.4f, (float)0.1f, (float)0.0f);
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected void preRenderCallback(AquaFishEntity fishEntity, float partialTickTime) {
        ResourceLocation location = fishEntity.func_200600_R().getRegistryName();
        float scale = 0.0f;
        if (location != null) {
            switch (location.func_110623_a()) {
                case "minnow": {
                    scale = 0.5f;
                    break;
                }
                case "synodontis": {
                    scale = 0.8f;
                    break;
                }
                case "brown_trout": 
                case "piranha": {
                    scale = 0.9f;
                    break;
                }
                case "pollock": {
                    scale = 1.1f;
                    break;
                }
                case "atlantic_cod": 
                case "blackfish": 
                case "catfish": 
                case "tambaqui": {
                    scale = 1.2f;
                    break;
                }
                case "pacific_halibut": 
                case "atlantic_halibut": 
                case "capitaine": 
                case "largemouth_bass": 
                case "gar": 
                case "arapaima": 
                case "tuna": {
                    scale = 1.4f;
                }
            }
        }
        if (scale > 0.0f) {
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        }
    }
}

