/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class AquaBobberRenderer
extends EntityRenderer<AquaFishingBobberEntity> {
    private static final ResourceLocation BOBBER = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = new ResourceLocation("aquaculture", "textures/entity/rod/hook/hook.png");

    public AquaBobberRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void doRender(@Nonnull AquaFishingBobberEntity bobber, double x, double y, double z, float entityYaw, float partialTicks) {
        PlayerEntity angler = bobber.func_190619_l();
        if (angler != null && !this.field_188301_f) {
            IDyeableArmorItem lineItem;
            double anglerEye;
            double anglerZ;
            double anglerY;
            double anglerX;
            double fov;
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.enableRescaleNormal();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            if (bobber.hasBobber()) {
                this.func_110776_a(BOBBER_OVERLAY);
            } else {
                this.func_180548_c((Entity)bobber);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            GlStateManager.rotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.field_188301_f) {
                GlStateManager.enableColorMaterial();
                GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)bobber));
            }
            if (bobber.hasBobber()) {
                ItemStack bobberStack = bobber.getBobber();
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                if (!bobberStack.func_190926_b() && bobberStack.func_77973_b() instanceof IDyeableArmorItem) {
                    int colorInt = ((IDyeableArmorItem)bobberStack.func_77973_b()).func_200886_f(bobberStack);
                    r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                    g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                    b = (float)(colorInt & 0xFF) / 255.0f;
                }
                builder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                builder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            } else {
                builder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                builder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            if (this.field_188301_f) {
                GlStateManager.tearDownSolidRenderingTextureCombine();
                GlStateManager.disableColorMaterial();
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            int hand = angler.func_184591_cq() == HandSide.RIGHT ? 1 : -1;
            ItemStack heldMain = angler.func_184614_ca();
            if (!(heldMain.func_77973_b() instanceof FishingRodItem)) {
                hand = -hand;
            }
            float swingProgress = angler.func_70678_g(partialTicks);
            float swingProgressSqrt = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
            float yawOffset = MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70760_ar, (float)angler.field_70761_aq) * ((float)Math.PI / 180);
            double sin = MathHelper.func_76126_a((float)yawOffset);
            double cos = MathHelper.func_76134_b((float)yawOffset);
            double handOffset = (double)hand * 0.35;
            if ((this.field_76990_c.field_78733_k == null || this.field_76990_c.field_78733_k.field_74320_O <= 0) && angler == Minecraft.func_71410_x().field_71439_g) {
                fov = Objects.requireNonNull(this.field_76990_c.field_78733_k).field_74334_X;
                Vec3d rod = new Vec3d((double)hand * -0.36 * (fov /= 100.0), -0.045 * fov, 0.4);
                rod = rod.func_178789_a(-MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70127_C, (float)angler.field_70125_A) * ((float)Math.PI / 180));
                rod = rod.func_178785_b(-MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70126_B, (float)angler.field_70177_z) * ((float)Math.PI / 180));
                rod = rod.func_178785_b(swingProgressSqrt * 0.5f);
                rod = rod.func_178789_a(-swingProgressSqrt * 0.7f);
                anglerX = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70169_q, (double)angler.field_70165_t) + rod.field_72450_a;
                anglerY = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70167_r, (double)angler.field_70163_u) + rod.field_72448_b;
                anglerZ = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70166_s, (double)angler.field_70161_v) + rod.field_72449_c;
                anglerEye = angler.func_70047_e();
            } else {
                anglerX = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70169_q, (double)angler.field_70165_t) - cos * handOffset - sin * 0.8;
                anglerY = angler.field_70167_r + (double)angler.func_70047_e() + (angler.field_70163_u - angler.field_70167_r) * (double)partialTicks - 0.45;
                anglerZ = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70166_s, (double)angler.field_70161_v) - sin * handOffset + cos * 0.8;
                anglerEye = angler.func_213287_bg() ? -0.1875 : 0.0;
            }
            fov = MathHelper.func_219803_d((double)partialTicks, (double)bobber.field_70169_q, (double)bobber.field_70165_t);
            double bobberY = MathHelper.func_219803_d((double)partialTicks, (double)bobber.field_70167_r, (double)bobber.field_70163_u) + 0.25;
            double bobberZ = MathHelper.func_219803_d((double)partialTicks, (double)bobber.field_70166_s, (double)bobber.field_70161_v);
            double startX = (float)(anglerX - fov);
            double startY = (double)((float)(anglerY - bobberY)) + anglerEye;
            double startZ = (float)(anglerZ - bobberZ);
            GlStateManager.disableTexture();
            GlStateManager.disableLighting();
            builder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            ItemStack line = bobber.getFishingLine();
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (!line.func_190926_b() && (lineItem = (IDyeableArmorItem)line.func_77973_b()).func_200883_f_(line)) {
                int colorInt = lineItem.func_200886_f(line);
                r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                b = (float)(colorInt & 0xFF) / 255.0f;
            }
            for (int size = 0; size <= 16; ++size) {
                float length = (float)size / 16.0f;
                builder.func_181662_b(x + startX * (double)length, y + startY * (double)(length * length + length) * 0.5 + 0.25, z + startZ * (double)length).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.enableLighting();
            GlStateManager.enableTexture();
            super.func_76986_a((Entity)bobber, x, y, z, entityYaw, partialTicks);
        }
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(@Nonnull AquaFishingBobberEntity bobber, double x, double y, double z, float entityYaw, float partialTicks) {
        PlayerEntity angler = bobber.func_190619_l();
        if (angler != null && !this.field_188301_f) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.enableRescaleNormal();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            if (bobber.hasHook()) {
                this.func_110776_a(bobber.getHook().getTexture());
            } else {
                this.func_110776_a(HOOK);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            GlStateManager.rotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.field_188301_f) {
                GlStateManager.enableColorMaterial();
                GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)bobber));
            }
            builder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            builder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            if (this.field_188301_f) {
                GlStateManager.tearDownSolidRenderingTextureCombine();
                GlStateManager.disableColorMaterial();
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            super.func_188300_b((Entity)bobber, x, y, z, entityYaw, partialTicks);
        }
    }

    protected void renderName(@Nonnull AquaFishingBobberEntity bobber, double x, double y, double z) {
        PlayerEntity angler;
        if (bobber.hasBobber() && (angler = bobber.func_190619_l()) != null && !this.field_188301_f) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.enableRescaleNormal();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.func_110776_a(BOBBER);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            GlStateManager.rotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            if (this.field_188301_f) {
                GlStateManager.enableColorMaterial();
                GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)bobber));
            }
            builder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            builder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            if (this.field_188301_f) {
                GlStateManager.tearDownSolidRenderingTextureCombine();
                GlStateManager.disableColorMaterial();
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull AquaFishingBobberEntity fishHook) {
        return BOBBER_VANILLA;
    }
}

