/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.talent;

import doggytalents.ModTags;
import doggytalents.api.inferface.IDogEntity;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.EntityDog;
import doggytalents.entity.ai.EntityAIFetch;
import doggytalents.helper.CapabilityHelper;
import doggytalents.helper.DogUtil;
import doggytalents.inventory.PackPuppyItemHandler;
import doggytalents.inventory.container.ContainerPackPuppy;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class PackPuppyTalent
extends Talent {
    @CapabilityInject(value=PackPuppyItemHandler.class)
    public static Capability<PackPuppyItemHandler> PACK_PUPPY_CAPABILITY = null;
    public static Predicate<ItemEntity> SHOULD_PICKUP_ENTITY_ITEM = entity -> entity.func_70089_S() && !entity.func_92059_d().func_77973_b().func_206844_a(ModTags.PACK_PUPPY_BLACKLIST) && !EntityAIFetch.BONE_PREDICATE.test(entity.func_92059_d());

    @Override
    public void onClassCreation(IDogEntity dog) {
        dog.putObject("packpuppyinventory", LazyOptional.of(() -> new PackPuppyItemHandler((EntityDog)dog)));
    }

    @Override
    public void writeAdditional(IDogEntity dog, CompoundNBT nbt) {
        PackPuppyItemHandler inventory = CapabilityHelper.getOrThrow(dog, PACK_PUPPY_CAPABILITY);
        nbt.func_197643_a(inventory.serializeNBT());
    }

    @Override
    public void readAdditional(IDogEntity dog, CompoundNBT nbt) {
        PackPuppyItemHandler inventory = CapabilityHelper.getOrThrow(dog, PACK_PUPPY_CAPABILITY);
        inventory.deserializeNBT(nbt);
    }

    @Override
    public void onLevelReset(IDogEntity dog, int preLevel) {
        if (preLevel > 0) {
            PackPuppyItemHandler inventory = CapabilityHelper.getOrThrow(dog, PACK_PUPPY_CAPABILITY);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)dog.field_70170_p, (double)dog.field_70165_t, (double)dog.field_70163_u, (double)dog.field_70161_v, (ItemStack)inventory.getStackInSlot(i));
                inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public ActionResultType onInteract(final IDogEntity dogIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int level = dogIn.getTalentFeature().getLevel(this);
        if (dogIn.func_70909_n() && level > 0 && playerIn.func_70093_af() && stack.func_190926_b() && !playerIn.field_70170_p.field_72995_K && dogIn.canInteract((LivingEntity)playerIn)) {
            if (playerIn instanceof ServerPlayerEntity && !(playerIn instanceof FakePlayer)) {
                ServerPlayerEntity entityPlayerMP = (ServerPlayerEntity)playerIn;
                NetworkHooks.openGui((ServerPlayerEntity)entityPlayerMP, (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
                        return new ContainerPackPuppy(windowId, inventory, (EntityDog)dogIn);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("container.doggytalents.pack_puppy", new Object[0]);
                    }
                }, buf -> buf.writeInt(dogIn.func_145782_y()));
            }
            dogIn.func_184185_a(SoundEvents.field_187657_V, 0.5f, dogIn.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void livingTick(IDogEntity dog) {
        if (!dog.field_70170_p.field_72995_K && dog.getTalentFeature().getLevel(this) >= 5 && dog.func_110143_aJ() > 1.0f) {
            IItemHandler inventory = (IItemHandler)CapabilityHelper.getOrThrow(dog, PACK_PUPPY_CAPABILITY);
            List list = dog.field_70170_p.func_175647_a(ItemEntity.class, dog.func_174813_aQ().func_72314_b(2.5, 1.0, 2.5), SHOULD_PICKUP_ENTITY_ITEM);
            for (ItemEntity entityItem : list) {
                ItemStack remaining = DogUtil.addItem(inventory, entityItem.func_92059_d());
                if (!remaining.func_190926_b()) {
                    entityItem.func_92058_a(remaining);
                    continue;
                }
                entityItem.func_70106_y();
                dog.func_184185_a(SoundEvents.field_187638_cR, 0.25f, ((dog.field_70170_p.field_73012_v.nextFloat() - dog.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(IDogEntity dogIn, Capability<T> cap, Direction side) {
        if (cap == PACK_PUPPY_CAPABILITY) {
            return ((LazyOptional)dogIn.getObject("packpuppyinventory", LazyOptional.class)).cast();
        }
        return null;
    }

    @Override
    public void invalidateCapabilities(IDogEntity dogIn) {
        ((LazyOptional)dogIn.getObject("packpuppyinventory", LazyOptional.class)).invalidate();
    }
}

