/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.serializer;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.Talent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TalentListSerializer
implements IDataSerializer<Map<Talent, Integer>> {
    public void write(PacketBuffer buf, Map<Talent, Integer> value) {
        buf.writeInt(value.size());
        for (Map.Entry<Talent, Integer> entry : value.entrySet()) {
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS, (IForgeRegistryEntry)entry.getKey());
            buf.writeByte(entry.getValue().intValue());
        }
    }

    public Map<Talent, Integer> read(PacketBuffer buf) {
        HashMap<Talent, Integer> map = new HashMap<Talent, Integer>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Talent talent = (Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS);
            byte level = buf.readByte();
            map.put(talent, Integer.valueOf(level));
        }
        return map;
    }

    public DataParameter<Map<Talent, Integer>> func_187161_a(int id) {
        return new DataParameter(id, (IDataSerializer)this);
    }

    public Map<Talent, Integer> copyValue(Map<Talent, Integer> value) {
        HashMap<Talent, Integer> copy = new HashMap<Talent, Integer>();
        for (Map.Entry<Talent, Integer> entry : value.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }
}

