/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.client;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.EntityDog;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDogTalent {
    public int entityId;
    public ResourceLocation talentId;

    public PacketDogTalent(int entityId, ResourceLocation talentId) {
        this.entityId = entityId;
        this.talentId = talentId;
    }

    public static void encode(PacketDogTalent msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_192572_a(msg.talentId);
    }

    public static PacketDogTalent decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        ResourceLocation talentId = buf.func_192575_l();
        return new PacketDogTalent(entityId, talentId);
    }

    public static class Handler {
        public static void handle(PacketDogTalent msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity target = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(msg.entityId);
                if (!(target instanceof EntityDog)) {
                    return;
                }
                EntityDog dog = (EntityDog)target;
                if (!dog.canInteract((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                    return;
                }
                Talent talent = (Talent)DoggyTalentsAPI.TALENTS.getValue(msg.talentId);
                int level = dog.TALENTS.getLevel(talent);
                if (level < talent.getHighestLevel(dog) && dog.spendablePoints() >= talent.getCost(dog, level + 1)) {
                    dog.TALENTS.setLevel(talent, level + 1);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

