/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.item;

import doggytalents.inventory.TreatBagItemHandler;
import doggytalents.inventory.container.ContainerTreatBag;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemTreatBag
extends Item {
    public ItemTreatBag(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        final ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        final int slotId = playerIn.field_71071_by.field_70461_c;
        if (playerIn instanceof ServerPlayerEntity && !(playerIn instanceof FakePlayer)) {
            ServerPlayerEntity entityPlayerMP = (ServerPlayerEntity)playerIn;
            NetworkHooks.openGui((ServerPlayerEntity)entityPlayerMP, (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
                    return new ContainerTreatBag(windowId, inventory, slotId, itemstack);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("container.doggytalents.treat_bag", new Object[0]);
                }
            }, buf -> {
                buf.func_150787_b(slotId);
                buf.func_150788_a(itemstack);
            });
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IItemHandler bagInventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
        List<ItemStack> condensedContents = this.getContentOverview(bagInventory);
        condensedContents.forEach(food -> tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".contents", new Object[]{food.func_190916_E(), new TranslationTextComponent(food.func_77977_a(), new Object[0])})));
    }

    public List<ItemStack> getContentOverview(IItemHandler bagInventory) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack itemstack = bagInventory.getStackInSlot(i).func_77946_l();
            if (itemstack.func_190926_b()) continue;
            boolean found = false;
            for (int j = 0; j < items.size(); ++j) {
                ItemStack stack = (ItemStack)items.get(j);
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemstack)) continue;
                stack.func_190917_f(itemstack.func_190916_E());
                found = true;
            }
            if (found) continue;
            items.add(itemstack);
        }
        return items;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == null) {
            return null;
        }
        return new ICapabilityProvider(){
            final LazyOptional<IItemHandler> itemHandlerInstance = LazyOptional.of(() -> new TreatBagItemHandler(stack));

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerInstance);
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

