/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.item;

import doggytalents.entity.ai.DogLocationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class ItemRadar
extends Item {
    public ItemRadar(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            DimensionType dimCurr = playerIn.field_71093_bK;
            playerIn.func_145747_a((ITextComponent)new StringTextComponent(""));
            DogLocationManager locationManager = DogLocationManager.getHandler((ServerWorld)worldIn);
            List<DogLocationManager.DogLocation> ownDogs = locationManager.getList(dimCurr, loc -> loc.getOwner(worldIn) == playerIn);
            if (ownDogs.isEmpty()) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornull", new Object[]{String.valueOf(DimensionType.func_212678_a((DimensionType)dimCurr))}));
            } else {
                boolean noRadioCollars = true;
                for (DogLocationManager.DogLocation loc2 : ownDogs) {
                    if (!loc2.hasRadioCollar(worldIn)) continue;
                    noRadioCollars = false;
                    String translateStr = ItemRadar.getDirectionTranslationKey(loc2, (Entity)playerIn);
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(translateStr, new Object[]{loc2.getName(worldIn), MathHelper.func_76143_f((double)Math.sqrt(playerIn.func_195048_a((Vec3d)loc2)))}));
                }
                if (noRadioCollars) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornoradio", new Object[0]));
                }
            }
            ArrayList<DimensionType> otherDogs = new ArrayList<DimensionType>();
            for (DimensionType dimType : DimensionType.func_212681_b()) {
                if (dimCurr == dimType || (ownDogs = (locationManager = DogLocationManager.getHandler((ServerWorld)worldIn)).getList(dimType, loc -> loc.getOwner(worldIn) == playerIn && loc.hasRadioCollar(worldIn))).size() <= 0) continue;
                otherDogs.add(dimType);
            }
            if (otherDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.notindim", new Object[]{otherDogs.stream().map(dim -> String.valueOf(DimensionType.func_212678_a((DimensionType)dim))).collect(Collectors.joining(", "))}));
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    public static String getDirectionTranslationKey(DogLocationManager.DogLocation loc, Entity entity) {
        double angle = MathHelper.func_181159_b((double)(loc.field_72450_a - entity.field_70165_t), (double)(loc.field_72449_c - entity.field_70161_v));
        if (angle < -2.748893571891069) {
            return "dogradar.north";
        }
        if (angle < -1.9634954084936207) {
            return "dogradar.north.west";
        }
        if (angle < -1.1780972450961724) {
            return "dogradar.west";
        }
        if (angle < -0.39269908169872414) {
            return "dogradar.south.west";
        }
        if (angle < 0.39269908169872414) {
            return "dogradar.south";
        }
        if (angle < 1.178097245096172) {
            return "dogradar.south.east";
        }
        if (angle < 1.9634954084936211) {
            return "dogradar.east";
        }
        if (angle < 2.7488935718910685) {
            return "dogradar.north.east";
        }
        return "dogradar.north";
    }
}

