/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.inventory.recipe;

import doggytalents.ModRecipes;
import doggytalents.api.inferface.IBedMaterial;
import doggytalents.block.DogBedRegistry;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class RecipeDogBed
extends SpecialRecipe
implements IShapedRecipe<CraftingInventory> {
    public RecipeDogBed(ResourceLocation resource) {
        super(resource);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        IBedMaterial beddingId = IBedMaterial.NULL;
        IBedMaterial casingId = IBedMaterial.NULL;
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                IBedMaterial id;
                if (col == 1 && row == 0 || col == 1 && row == 1) {
                    id = DogBedRegistry.BEDDINGS.getFromStack(inv.func_70301_a(col + row * inv.func_174922_i()));
                    if (id == IBedMaterial.NULL || beddingId != IBedMaterial.NULL && id != beddingId) {
                        return false;
                    }
                    beddingId = id;
                    continue;
                }
                id = DogBedRegistry.CASINGS.getFromStack(inv.func_70301_a(col + row * inv.func_174922_i()));
                if (id == IBedMaterial.NULL || beddingId != IBedMaterial.NULL && id != casingId) {
                    return false;
                }
                casingId = id;
            }
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        IBedMaterial beddingId = DogBedRegistry.BEDDINGS.getFromStack(inv.func_70301_a(1));
        IBedMaterial casingId = DogBedRegistry.CASINGS.getFromStack(inv.func_70301_a(0));
        return DogBedRegistry.createItemStack(casingId, beddingId);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.DOG_BED;
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }
}

