/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.features;

import doggytalents.api.feature.ILevelFeature;
import doggytalents.entity.EntityDog;
import doggytalents.entity.features.DogFeature;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.CompoundNBT;

public class LevelFeature
extends DogFeature
implements ILevelFeature {
    private static UUID HEALTH_BOOST_ID = UUID.fromString("da97255c-6281-45db-8198-f79226438583");

    public LevelFeature(EntityDog dogIn) {
        super(dogIn);
    }

    @Override
    public void writeAdditional(CompoundNBT compound) {
        compound.func_74768_a("level_normal", this.getLevel());
        compound.func_74768_a("level_dire", this.getDireLevel());
    }

    @Override
    public void readAdditional(CompoundNBT compound) {
        if (compound.func_74764_b("level_normal")) {
            this.setLevel(compound.func_74762_e("level_normal"));
        }
        if (compound.func_74764_b("level_dire")) {
            this.setDireLevel(compound.func_74762_e("level_dire"));
        }
        if (compound.func_150297_b("levels", 8)) {
            String[] split = compound.func_74779_i("levels").split(":");
            this.setLevel(new Integer(split[0]));
            this.setDireLevel(new Integer(split[1]));
        }
    }

    @Override
    public int getLevel() {
        return this.dog.getLevel();
    }

    @Override
    public int getDireLevel() {
        return this.dog.getDireLevel();
    }

    @Override
    public void increaseLevel() {
        this.setLevel(this.getLevel() + 1);
    }

    @Override
    public void increaseDireLevel() {
        this.setDireLevel(this.getDireLevel() + 1);
    }

    @Override
    public void setLevel(int level) {
        this.dog.setLevel(level);
        this.updateHealthModifier();
    }

    @Override
    public void setDireLevel(int level) {
        this.dog.setDireLevel(level);
        this.updateHealthModifier();
    }

    public void updateHealthModifier() {
        IAttributeInstance iattributeinstance = this.dog.func_110148_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier healthModifier = this.createHealthModifier(this.dog.effectiveLevel() + 1.0);
        if (iattributeinstance.func_111127_a(HEALTH_BOOST_ID) != null) {
            iattributeinstance.func_111124_b(healthModifier);
        }
        iattributeinstance.func_111121_a(healthModifier);
    }

    public AttributeModifier createHealthModifier(double health) {
        return new AttributeModifier(HEALTH_BOOST_ID, "Dog Health", health, AttributeModifier.Operation.ADDITION);
    }

    public boolean isDireDog() {
        return this.getDireLevel() == 30;
    }
}

