/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.api.inferface.IWaterMovement;
import doggytalents.entity.ai.WaterMovementHandler;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIExtinguishFire
extends Goal {
    private MobEntity creature;
    private GroundPathNavigator navigator;
    private final double movementSpeed;
    private final int searchLength;
    private IWaterMovement waterMovement;
    private int timeoutCounter;
    private boolean oldCanSwim;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;

    public EntityAIExtinguishFire(MobEntity creature, double speedIn, int length) {
        this.creature = creature;
        this.navigator = (GroundPathNavigator)creature.func_70661_as();
        this.movementSpeed = speedIn;
        this.searchLength = length;
        this.waterMovement = new WaterMovementHandler(creature);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        return this.creature.func_70027_ad() && this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter < 400 && this.creature.func_70027_ad() && this.shouldMoveTo(this.creature.field_70170_p, this.destinationBlock);
    }

    public void func_75249_e() {
        this.waterMovement.startExecuting();
        this.oldCanSwim = this.navigator.func_212238_t();
        this.navigator.func_212239_d(true);
        this.timeoutCounter = 0;
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.waterMovement.resetTask();
        this.navigator.func_212239_d(this.oldCanSwim);
    }

    public void func_75246_d() {
        ++this.timeoutCounter;
        if (this.timeoutCounter % 40 == 0) {
            this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, 1.0);
        }
    }

    private boolean searchForDestination() {
        BlockPos blockpos = new BlockPos((Entity)this.creature);
        int y = 0;
        while (y <= 5) {
            for (int s = 0; s < this.searchLength; ++s) {
                int x = 0;
                while (x <= s) {
                    int z;
                    int n = z = x < s && x > -s ? s : 0;
                    while (z <= s) {
                        BlockPos blockpos1 = blockpos.func_177982_a(x, y - 1, z);
                        if (this.shouldMoveTo(this.creature.field_70170_p, blockpos1)) {
                            this.destinationBlock = blockpos1;
                            return true;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return false;
    }

    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        if (worldIn.func_175727_C(pos)) {
            return true;
        }
        return this.isWaterDestination(worldIn, pos);
    }

    protected boolean isWaterDestination(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }
}

