/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.ModTags;
import doggytalents.entity.EntityDog;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class EntityAIBegDog
extends Goal {
    private final EntityDog dog;
    private final World world;
    private final float minPlayerDistance;
    private PlayerEntity player;
    private int timeoutCounter;

    public EntityAIBegDog(EntityDog dog, float minDistance) {
        this.dog = dog;
        this.world = dog.field_70170_p;
        this.minPlayerDistance = minDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        this.player = this.world.func_217362_a((Entity)this.dog, (double)this.minPlayerDistance);
        return this.player == null ? false : this.hasTemptationItemInHand(this.player);
    }

    public boolean func_75253_b() {
        if (!this.player.func_70089_S()) {
            return false;
        }
        if (this.dog.func_70068_e((Entity)this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    public void func_75249_e() {
        this.dog.setBegging(true);
        this.timeoutCounter = 40 + this.dog.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        this.dog.setBegging(false);
        this.player = null;
    }

    public void func_75246_d() {
        this.dog.func_70671_ap().func_75650_a(this.player.field_70165_t, this.player.field_70163_u + (double)this.player.func_70047_e(), this.player.field_70161_v, 10.0f, (float)this.dog.func_70646_bf());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(PlayerEntity player) {
        for (Hand enumhand : Hand.values()) {
            ItemStack itemstack = player.func_184586_b(enumhand);
            if (itemstack.func_77973_b().func_206844_a(this.dog.func_70909_n() ? ModTags.BEG_ITEMS_TAMED : ModTags.BEG_ITEMS_UNTAMED)) {
                return true;
            }
            if (this.dog.foodValue(itemstack, (Entity)player) > 0) {
                return true;
            }
            if (!this.dog.func_70877_b(itemstack)) continue;
            return true;
        }
        return false;
    }
}

