/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import com.google.common.base.Predicates;
import doggytalents.ModEntities;
import doggytalents.api.feature.EnumMode;
import doggytalents.entity.EntityDog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityDoggyBeam
extends ThrowableEntity
implements IRendersAsItem,
IEntityAdditionalSpawnData {
    private ItemStack renderItem;

    public EntityDoggyBeam(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        this(ModEntities.DOG_BEAM, worldIn);
    }

    public EntityDoggyBeam(EntityType<EntityDoggyBeam> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDoggyBeam(World worldIn, LivingEntity throwerIn) {
        super(ModEntities.DOG_BEAM, throwerIn, worldIn);
    }

    public void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
            LivingEntity thrower = this.func_85052_h();
            if (thrower != null && entityHit instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityHit;
                this.field_70170_p.func_217357_a(EntityDog.class, this.func_174813_aQ().func_72314_b(64.0, 16.0, 64.0)).stream().filter(Predicates.not(TameableEntity::func_70906_o)).filter(d -> d.MODE.isMode(EnumMode.AGGRESIVE, EnumMode.TACTICAL, EnumMode.BERSERKER)).filter(d -> d.canInteract(thrower)).filter(d -> d != livingEntity && d.func_142018_a(livingEntity, d.func_70902_q())).filter(d -> (double)d.func_70032_d(entityHit) < this.getTargetDistance((EntityDog)d)).forEach(d -> d.func_70624_b(livingEntity));
            }
            for (int j = 0; j < 8; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected double getTargetDistance(EntityDog dog) {
        IAttributeInstance iattributeinstance = dog.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    protected void func_70088_a() {
    }

    public ItemStack func_184543_l() {
        if (this.renderItem == null) {
            this.renderItem = new ItemStack((IItemProvider)Items.field_151126_ay);
        }
        return this.renderItem;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.field_96093_i != null);
        if (this.field_96093_i != null) {
            buffer.func_179252_a(this.field_96093_i);
        }
    }

    public void readSpawnData(PacketBuffer buffer) {
        boolean hasThrower = buffer.readBoolean();
        if (hasThrower) {
            this.field_96093_i = buffer.func_179253_g();
        }
    }
}

