/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.renderer.world;

import com.mojang.blaze3d.platform.GlStateManager;
import doggytalents.ModTalents;
import doggytalents.entity.EntityDog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class WorldRender {
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (Entity passenger : player.func_184188_bt()) {
            if (!(passenger instanceof EntityDog)) continue;
            EntityDog dog = (EntityDog)passenger;
            if (!dog.COORDS.hasBedPos()) continue;
            int level = dog.TALENTS.getLevel(ModTalents.BED_FINDER);
            double distance = (double)level * 200.0 - Math.sqrt(dog.COORDS.getBedPos().func_177951_i((Vec3i)dog.func_180425_c()));
            if (level != 5 && !(distance >= 0.0)) continue;
            GlStateManager.pushMatrix();
            AxisAlignedBB boundingBox = new AxisAlignedBB(dog.COORDS.getBedPos()).func_186662_g(0.5);
            WorldRender.drawSelectionBox((PlayerEntity)player, event.getPartialTicks(), boundingBox);
            GlStateManager.popMatrix();
        }
    }

    public static void drawSelectionBox(PlayerEntity player, float particleTicks, AxisAlignedBB boundingBox) {
        GlStateManager.disableAlphaTest();
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableDepthTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.disableTexture();
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)particleTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)particleTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)particleTicks;
        WorldRenderer.func_189697_a((AxisAlignedBB)boundingBox.func_72317_d(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        GlStateManager.enableDepthTest();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
    }
}

