/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.model.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import doggytalents.entity.EntityDog;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelDog
extends EntityModel<EntityDog> {
    public RendererModel head;
    public RendererModel body;
    public RendererModel legBackRight;
    public RendererModel legBackLeft;
    public RendererModel legFrontRight;
    public RendererModel legFrontLeft;
    public RendererModel tail;
    public RendererModel mane;

    public ModelDog(float scaleFactor) {
        float f1 = 13.5f;
        this.head = new RendererModel((Model)this, 0, 0);
        this.head.func_78790_a(-2.0f, -3.0f, -2.0f, 6, 6, 4, scaleFactor);
        this.head.func_78793_a(-1.0f, f1, -7.0f);
        this.body = new RendererModel((Model)this, 18, 14);
        this.body.func_78790_a(-3.0f, -2.0f, -3.0f, 6, 9, 6, scaleFactor);
        this.body.func_78793_a(0.0f, 14.0f, 2.0f);
        this.mane = new RendererModel((Model)this, 21, 0);
        this.mane.func_78790_a(-3.0f, -3.0f, -3.0f, 8, 6, 7, scaleFactor);
        this.mane.func_78793_a(-1.0f, 14.0f, 2.0f);
        this.legBackRight = new RendererModel((Model)this, 0, 18);
        this.legBackRight.func_78790_a(0.0f, 0.0f, -1.0f, 2, 8, 2, scaleFactor);
        this.legBackRight.func_78793_a(-2.5f, 16.0f, 7.0f);
        this.legBackLeft = new RendererModel((Model)this, 0, 18);
        this.legBackLeft.func_78790_a(0.0f, 0.0f, -1.0f, 2, 8, 2, scaleFactor);
        this.legBackLeft.func_78793_a(0.5f, 16.0f, 7.0f);
        this.legFrontRight = new RendererModel((Model)this, 0, 18);
        this.legFrontRight.func_78790_a(0.0f, 0.0f, -1.0f, 2, 8, 2, scaleFactor);
        this.legFrontRight.func_78793_a(-2.5f, 16.0f, -4.0f);
        this.legFrontLeft = new RendererModel((Model)this, 0, 18);
        this.legFrontLeft.func_78790_a(0.0f, 0.0f, -1.0f, 2, 8, 2, scaleFactor);
        this.legFrontLeft.func_78793_a(0.5f, 16.0f, -4.0f);
        this.tail = new RendererModel((Model)this, 9, 18);
        this.tail.func_78790_a(-0.5f, 0.0f, -1.0f, 2, 8, 2, scaleFactor);
        this.tail.func_78793_a(-0.5f, 12.0f, 8.0f);
        this.tail.func_78784_a(45, 0).func_78789_a(0.0f, 0.0f, 0.0f, 2, 3, 1).func_78793_a(90.0f, 0.0f, 0.0f);
        this.head.func_78784_a(16, 14).func_78790_a(-2.0f, -5.0f, 0.0f, 2, 2, 1, scaleFactor);
        this.head.func_78784_a(16, 14).func_78790_a(2.0f, -5.0f, 0.0f, 2, 2, 1, scaleFactor);
        this.head.func_78784_a(42, 14).func_78790_a(-3.0f, -3.0f, -1.5f, 1, 5, 3, scaleFactor);
        this.head.func_78784_a(42, 14).func_78790_a(4.0f, -3.0f, -1.5f, 1, 5, 3, scaleFactor);
        this.head.func_78784_a(18, 0).func_78790_a(-2.8f, -3.5f, -1.0f, 2, 1, 2, scaleFactor);
        this.head.func_78784_a(18, 0).func_78790_a(2.8f, -3.5f, -1.0f, 2, 1, 2, scaleFactor);
        this.head.func_78784_a(0, 10).func_78790_a(-0.5f, 0.0f, -5.0f, 3, 3, 4, scaleFactor);
    }

    public void render(EntityDog dogIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.func_78088_a((Entity)dogIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.setRotationAngles(dogIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.field_217114_e) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)(5.0f * scale), (float)(2.0f * scale));
            this.head.func_78791_b(scale);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.body.func_78785_a(scale);
            this.legBackRight.func_78785_a(scale);
            this.legBackLeft.func_78785_a(scale);
            this.legFrontRight.func_78785_a(scale);
            this.legFrontLeft.func_78785_a(scale);
            this.tail.func_78791_b(scale);
            this.mane.func_78785_a(scale);
            GlStateManager.popMatrix();
        } else {
            this.head.func_78791_b(scale);
            this.body.func_78785_a(scale);
            this.legBackRight.func_78785_a(scale);
            this.legBackLeft.func_78785_a(scale);
            this.legFrontRight.func_78785_a(scale);
            this.legFrontLeft.func_78785_a(scale);
            this.tail.func_78791_b(scale);
            this.mane.func_78785_a(scale);
        }
    }

    public void setLivingAnimations(EntityDog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (dog.func_70906_o()) {
            this.mane.func_78793_a(-1.0f, 16.0f, -3.0f);
            this.mane.field_78795_f = 1.2566371f;
            this.mane.field_78796_g = 0.0f;
            this.body.func_78793_a(0.0f, 18.0f, 0.0f);
            this.body.field_78795_f = 0.7853982f;
            this.tail.func_78793_a(-0.5f, 21.0f, 6.0f);
            this.legBackRight.func_78793_a(-2.5f, 22.0f, 2.0f);
            this.legBackRight.field_78795_f = 4.712389f;
            this.legBackLeft.func_78793_a(0.5f, 22.0f, 2.0f);
            this.legBackLeft.field_78795_f = 4.712389f;
            this.legFrontRight.field_78795_f = 5.811947f;
            this.legFrontRight.func_78793_a(-2.49f, 17.0f, -4.0f);
            this.legFrontLeft.field_78795_f = 5.811947f;
            this.legFrontLeft.func_78793_a(0.51f, 17.0f, -4.0f);
            this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
            this.legFrontRight.field_78796_g = 0.0f;
            this.legFrontLeft.field_78796_g = 0.0f;
        } else if (dog.isLyingDown()) {
            this.body.func_78793_a(0.0f, 14.0f, 0.0f);
            this.body.field_78795_f = 1.5707964f;
            this.mane.func_78793_a(-1.0f, 19.0f, -3.0f);
            this.mane.field_78795_f = this.body.field_78795_f;
            this.head.func_78793_a(-1.0f, 17.0f, -7.0f);
            this.tail.func_78793_a(-0.5f, 17.0f, 8.0f);
            this.legBackRight.func_78793_a(-4.5f, 20.0f, 7.0f);
            this.legBackLeft.func_78793_a(2.5f, 20.0f, 7.0f);
            this.legFrontRight.func_78793_a(-3.0f, 22.0f, -3.0f);
            this.legFrontLeft.func_78793_a(1.0f, 22.0f, -3.0f);
            this.legBackRight.field_78795_f = -1.208305f;
            this.legBackLeft.field_78795_f = -1.208305f;
            this.legFrontRight.field_78795_f = -1.5707964f;
            this.legFrontRight.field_78796_g = 0.31415927f;
            this.legFrontLeft.field_78795_f = -1.5707964f;
            this.legFrontLeft.field_78796_g = -0.31415927f;
        } else {
            if (dog.isLyingDown()) {
                // empty if block
            }
            this.body.func_78793_a(0.0f, 14.0f, 2.0f);
            this.body.field_78795_f = 1.5707964f;
            this.mane.func_78793_a(-1.0f, 14.0f, -3.0f);
            this.mane.field_78795_f = this.body.field_78795_f;
            this.tail.func_78793_a(-0.5f, 12.0f, 8.0f);
            this.legBackRight.func_78793_a(-2.5f, 16.0f, 7.0f);
            this.legBackLeft.func_78793_a(0.5f, 16.0f, 7.0f);
            this.legFrontRight.func_78793_a(-2.5f, 16.0f, -4.0f);
            this.legFrontLeft.func_78793_a(0.5f, 16.0f, -4.0f);
            this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
            this.legFrontRight.field_78796_g = 0.0f;
            this.legFrontLeft.field_78796_g = 0.0f;
        }
        this.head.field_78808_h = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
        this.mane.field_78808_h = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.field_78808_h = dog.getShakeAngle(partialTickTime, -0.16f);
        this.tail.field_78808_h = dog.getShakeAngle(partialTickTime, -0.2f);
        if (dog.func_70906_o() || dog.func_213322_ci().equals((Object)Vec3d.field_186680_a)) {
            this.tail.field_78796_g = dog.getWagAngle(partialTickTime, 0.0f);
        }
    }

    public void setRotationAngles(EntityDog dogIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        super.func_212844_a_((Entity)dogIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.tail.field_78795_f = ageInTicks;
    }
}

