/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.model.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import doggytalents.ModBeddings;
import doggytalents.api.inferface.IBedMaterial;
import doggytalents.block.BlockDogBed;
import doggytalents.client.model.block.DogBedItemOverride;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements IBakedModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private ModelLoader modelLoader;
    private BlockModel model;
    private IBakedModel bakedModel;
    private final VertexFormat format;
    private final Map<Triple<String, String, Direction>, IBakedModel> cache = Maps.newHashMap();

    public DogBedModel(ModelLoader modelLoader, BlockModel model, IBakedModel bakedModel, VertexFormat format) {
        this.modelLoader = modelLoader;
        this.model = model;
        this.bakedModel = bakedModel;
        this.format = format;
    }

    public IBakedModel getCustomModel(IBedMaterial casing, IBedMaterial bedding, Direction facing) {
        if (casing == null) {
            casing = ModBeddings.OAK;
        }
        if (bedding == null) {
            bedding = ModBeddings.WHITE;
        }
        if (facing == null) {
            facing = Direction.NORTH;
        }
        String casingTex = casing.getTexture();
        String beddingTex = bedding.getTexture();
        return this.getCustomModel(casingTex, beddingTex, facing);
    }

    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.getCustomModel(ModBeddings.OAK, ModBeddings.WHITE, Direction.NORTH).func_200117_a(state, side, rand);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        IBedMaterial casing = (IBedMaterial)data.getData(TileEntityDogBed.CASING);
        IBedMaterial bedding = (IBedMaterial)data.getData(TileEntityDogBed.BEDDING);
        Direction facing = (Direction)data.getData(TileEntityDogBed.FACING);
        return this.getCustomModel(casing, bedding, facing).func_200117_a(state, side, rand);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        IBedMaterial casing = (IBedMaterial)data.getData(TileEntityDogBed.CASING);
        IBedMaterial bedding = (IBedMaterial)data.getData(TileEntityDogBed.BEDDING);
        Direction facing = (Direction)data.getData(TileEntityDogBed.FACING);
        return this.getCustomModel(casing, bedding, facing).func_177554_e();
    }

    public IModelData getModelData(@Nonnull IEnviromentBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        IBedMaterial casing = ModBeddings.OAK;
        IBedMaterial bedding = ModBeddings.WHITE;
        Direction facing = Direction.NORTH;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDogBed) {
            casing = ((TileEntityDogBed)tile).getCasingId();
            bedding = ((TileEntityDogBed)tile).getBeddingId();
        }
        if (state.func_196959_b((IProperty)BlockDogBed.FACING)) {
            facing = (Direction)state.func_177229_b((IProperty)BlockDogBed.FACING);
        }
        tileData.setData(TileEntityDogBed.CASING, (Object)casing);
        tileData.setData(TileEntityDogBed.BEDDING, (Object)bedding);
        tileData.setData(TileEntityDogBed.FACING, (Object)facing);
        return tileData;
    }

    public IBakedModel getCustomModel(@Nonnull String casingResource, @Nonnull String beddingResource, @Nonnull Direction facing) {
        IBakedModel customModel = this.bakedModel;
        ImmutableTriple key = ImmutableTriple.of((Object)casingResource, (Object)beddingResource, (Object)facing);
        IBakedModel possibleModel = this.cache.get(key);
        if (possibleModel != null) {
            customModel = possibleModel;
        } else if (this.model != null) {
            ArrayList elements = Lists.newArrayList();
            for (BlockPart part : this.model.func_178298_a()) {
                elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
            }
            BlockModel newModel = new BlockModel(this.model.getParentLocation(), (List)elements, (Map)Maps.newHashMap((Map)this.model.field_178318_c), this.model.func_178309_b(), this.model.func_178311_c(), this.model.func_181682_g(), (List)Lists.newArrayList((Iterable)this.model.func_187966_f()));
            newModel.field_178317_b = this.model.field_178317_b;
            newModel.field_178315_d = this.model.field_178315_d;
            newModel.field_178318_c.put("bedding", beddingResource);
            newModel.field_178318_c.put("casing", casingResource);
            newModel.field_178318_c.put("particle", casingResource);
            customModel = newModel.bake((ModelBakery)this.modelLoader, ModelLoader.defaultTextureGetter(), (ISprite)TRSRTransformation.getRotation((Direction)facing), this.format);
            this.cache.put((Triple<String, String, Direction>)key, customModel);
        }
        return customModel;
    }

    public boolean func_177555_b() {
        return this.bakedModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return ITEM_OVERIDE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.bakedModel.handlePerspective(cameraTransformType).getRight());
    }
}

