/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.DoggyTalentsMod;
import doggytalents.api.inferface.IBedMaterial;
import doggytalents.block.DogBedRegistry;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockDogBed
extends ContainerBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockDogBed() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 5.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_179543_a("doggytalents");
        if (tag != null) {
            IBedMaterial casingId = DogBedRegistry.CASINGS.get(tag.func_74779_i("casingId"));
            IBedMaterial beddingId = DogBedRegistry.BEDDINGS.get(tag.func_74779_i("beddingId"));
            tooltip.add(casingId.getTooltip());
            tooltip.add(beddingId.getTooltip());
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        for (IBedMaterial beddingId : DogBedRegistry.BEDDINGS.getKeys()) {
            for (IBedMaterial casingId : DogBedRegistry.CASINGS.getKeys()) {
                items.add((Object)DogBedRegistry.createItemStack(casingId, beddingId));
            }
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityDogBed();
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE_COLLISION;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        state = (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            CompoundNBT tag = stack.func_77978_p().func_74775_l("doggytalents");
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tile;
                dogBed.setBeddingId(DogBedRegistry.BEDDINGS.get(tag.func_74779_i("beddingId")));
                dogBed.setCasingId(DogBedRegistry.CASINGS.get(tag.func_74779_i("casingId")));
            }
        }
        worldIn.func_180501_a(pos, state, 2);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDogBed) {
            IBedMaterial casing = ((TileEntityDogBed)tile).getCasingId();
            IBedMaterial bedding = ((TileEntityDogBed)tile).getBeddingId();
            return DogBedRegistry.createItemStack(casing, bedding);
        }
        DoggyTalentsMod.LOGGER.debug("Unable to get data from TileEntityDogBed. This should never happen.");
        return ItemStack.field_190927_a;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return BlockDogBed.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }
}

