/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.ModBeddings;
import doggytalents.ModBlocks;
import doggytalents.ModContainerTypes;
import doggytalents.ModEntities;
import doggytalents.ModItems;
import doggytalents.ModRecipes;
import doggytalents.ModRegistries;
import doggytalents.ModSerializers;
import doggytalents.ModSounds;
import doggytalents.ModTalents;
import doggytalents.ModTileEntities;
import doggytalents.addon.AddonManager;
import doggytalents.api.BeddingRegistryEvent;
import doggytalents.api.inferface.Talent;
import doggytalents.block.DogBedRegistry;
import doggytalents.client.gui.GuiFoodBowl;
import doggytalents.client.gui.GuiPackPuppy;
import doggytalents.client.gui.GuiTreatBag;
import doggytalents.client.renderer.entity.RenderDog;
import doggytalents.client.renderer.entity.RenderDogBeam;
import doggytalents.client.renderer.world.WorldRender;
import doggytalents.configuration.ConfigHandler;
import doggytalents.data.DTItemTagsProvider;
import doggytalents.data.DTRecipeProvider;
import doggytalents.entity.EntityDog;
import doggytalents.entity.EntityDoggyBeam;
import doggytalents.handler.EntityInteract;
import doggytalents.handler.EntitySpawn;
import doggytalents.handler.GameOverlay;
import doggytalents.handler.InputUpdate;
import doggytalents.handler.LivingDrops;
import doggytalents.handler.MissingMappings;
import doggytalents.handler.PlayerConnection;
import doggytalents.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DataSerializerEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="doggytalents")
public class DoggyTalentsMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"Doggy Talents");
    private static final String PROTOCOL_VERSION = Integer.toString(2);
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("doggytalents", "channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static DoggyTalentsMod INSTANCE;

    public DoggyTalentsMod() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Item.class, ModItems::registerItems);
        modEventBus.addGenericListener(Block.class, ModBlocks::registerBlocks);
        modEventBus.addGenericListener(Item.class, ModBlocks::registerItemBlocks);
        modEventBus.addGenericListener(EntityType.class, ModEntities::registerEntities);
        modEventBus.addGenericListener(ContainerType.class, ModContainerTypes::registerContainers);
        modEventBus.addGenericListener(DataSerializerEntry.class, ModSerializers::registerSerializers);
        modEventBus.addGenericListener(SoundEvent.class, ModSounds::registerSoundEvents);
        modEventBus.addGenericListener(IRecipeSerializer.class, ModRecipes::registerRecipes);
        modEventBus.addGenericListener(TileEntityType.class, ModTileEntities::registerTileEntities);
        modEventBus.addGenericListener(Talent.class, ModTalents::registerTalents);
        modEventBus.addListener(ModRegistries::newRegistry);
        modEventBus.addListener(ModBeddings::registerBeddingMaterial);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::interModProcess);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.register((Object)new PlayerConnection());
        forgeEventBus.register((Object)new MissingMappings());
        forgeEventBus.register((Object)new EntityInteract());
        forgeEventBus.register((Object)new LivingDrops());
        forgeEventBus.register((Object)new EntitySpawn());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(ModBlocks::registerBlockColours);
            modEventBus.addListener(ModItems::registerItemColours);
            forgeEventBus.addListener(GameOverlay::onPreRenderGameOverlay);
            forgeEventBus.addListener(InputUpdate::on);
            forgeEventBus.addListener(WorldRender::onWorldRenderLast);
        });
        ConfigHandler.init();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        ConfigHandler.initTalentConfig();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ModContainerTypes.FOOD_BOWL, GuiFoodBowl::new);
        ScreenManager.func_216911_a(ModContainerTypes.PACK_PUPPY, GuiPackPuppy::new);
        ScreenManager.func_216911_a(ModContainerTypes.TREAT_BAG, GuiTreatBag::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDog.class, RenderDog::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDoggyBeam.class, RenderDogBeam::new);
    }

    protected void interModProcess(InterModProcessEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().post((Event)new BeddingRegistryEvent(DogBedRegistry.CASINGS, DogBedRegistry.BEDDINGS));
        AddonManager.runRegisteredAddons();
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new DTItemTagsProvider(gen));
            gen.func_200390_a((IDataProvider)new DTRecipeProvider(gen));
        }
    }
}

