/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world.planttopia.biomes.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kaneka.planttech2.registries.ModBiomes;
import net.kaneka.planttech2.world.planttopia.PlantTopiaGenSettings;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;

public class PlantTopiaBiomeLayer
implements IC0Transformer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final PlantTopiaGenSettings settings;

    public static ImmutableList<BiomeManager.BiomeEntry> getBiomesToGeneration() {
        ArrayList<BiomeManager.BiomeEntry> list = new ArrayList<BiomeManager.BiomeEntry>();
        list.add(new BiomeManager.BiomeEntry(ModBiomes.PLANTTOPIA_PLAINS, 100));
        list.add(new BiomeManager.BiomeEntry(ModBiomes.PLANTTOPIA_FOREST, 60));
        return ImmutableList.copyOf(list);
    }

    public PlantTopiaBiomeLayer(WorldType p_i48641_1_, PlantTopiaGenSettings p_i48641_2_) {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList<BiomeManager.BiomeEntry> biomesToAdd = PlantTopiaBiomeLayer.getBiomesToGeneration();
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        this.settings = p_i48641_1_ == WorldType.field_77136_e ? null : p_i48641_2_;
    }

    public int func_202726_a(INoiseRandom context, int value) {
        if (this.settings != null && this.settings.func_202199_l() >= 0) {
            return this.settings.func_202199_l();
        }
        return Registry.field_212624_m.func_148757_b((Object)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (INoiseRandom)context).biome);
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

