/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.container.PlantFarmContainer;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class PlantFarmTileEntity
extends EnergyInventoryTileEntity {
    private int actualX = 0;
    private int actualY = 0;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return PlantFarmTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return PlantFarmTileEntity.this.energystorage.getMaxEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    PlantFarmTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    PlantFarmTileEntity.this.energystorage.setEnergyMaxStored(value);
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public PlantFarmTileEntity() {
        super(ModTileEntities.PLANTFARM_TE, 1000, 19);
    }

    @Override
    public void doUpdate() {
        if ((float)this.field_145850_b.func_82737_E() % (400.0f - (float)this.getSpeedReduction() * 45.0f) == 0.0f) {
            ++this.actualX;
            int range = this.getRange();
            int diameter = range * 2 + 1;
            if (this.actualX >= diameter) {
                this.actualX = 0;
                ++this.actualY;
                if (this.actualY >= diameter) {
                    this.actualY = 0;
                }
            }
            if (this.energystorage.getEnergyStored() >= this.getEnergyPerAction()) {
                BlockPos actualPos = this.field_174879_c.func_177982_a(this.actualX - range, 0, this.actualY - range);
                BlockState state = this.field_145850_b.func_180495_p(actualPos);
                if (this.field_145850_b.func_180495_p(actualPos).func_177230_c() instanceof CropBaseBlock && (Integer)state.func_177229_b((IProperty)CropBaseBlock.GROWSTATE) > 6) {
                    NonNullList drops = NonNullList.func_191196_a();
                    TileEntity te = this.field_145850_b.func_175625_s(actualPos);
                    if (te instanceof CropsTileEntity) {
                        ((CropsTileEntity)te).dropsRemoveOneSeed((NonNullList<ItemStack>)drops, 7);
                        for (ItemStack stack : drops) {
                            for (int i = 0; i < 15; ++i) {
                                if (stack.func_190926_b()) continue;
                                stack = this.itemhandler.insertItem(i, stack, false);
                            }
                            if (stack.func_190926_b()) continue;
                            PlantFarmTileEntity.spawnAsEntity(this.field_145850_b, this.field_174879_c.func_177984_a(), stack);
                        }
                        this.field_145850_b.func_175656_a(actualPos, (BlockState)state.func_206870_a((IProperty)CropBaseBlock.GROWSTATE, (Comparable)Integer.valueOf(0)));
                        this.energystorage.extractEnergy(this.getEnergyPerAction());
                    }
                }
            }
        }
        this.doEnergyLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    private int getEnergyPerAction() {
        return 20 + 40 * (this.getSpeedReduction() + this.getRange());
    }

    private int getSpeedReduction() {
        TierItem item;
        ItemStack stack = this.itemhandler.getStackInSlot(15);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof TierItem && (item = (TierItem)stack.func_77973_b()).getItemType() == 2) {
            return item.getTier();
        }
        return 0;
    }

    private int getRange() {
        TierItem item;
        ItemStack stack = this.itemhandler.getStackInSlot(16);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof TierItem && (item = (TierItem)stack.func_77973_b()).getItemType() == 1) {
            return item.getTier() + 1;
        }
        return 1;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("actualx", this.actualX);
        compound.func_74768_a("actualY", this.actualY);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.actualX = compound.func_74762_e("actualx");
        this.actualY = compound.func_74762_e("actualy");
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "plantfarm";
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new PlantFarmContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 17;
    }

    @Override
    public int getEnergyOutSlot() {
        return 18;
    }
}

