/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.registries;

import net.kaneka.planttech2.world.planttopia.biomes.PlantTopiaForestBiome;
import net.kaneka.planttech2.world.planttopia.biomes.PlantTopiaPlainsBiome;
import net.kaneka.planttech2.world.planttopia.biomes.PlantTopiaRiverBiome;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBiomes {
    public static final Biome PLANTTOPIA_PLAINS = new PlantTopiaPlainsBiome();
    public static final Biome PLANTTOPIA_FOREST = new PlantTopiaForestBiome();
    public static final Biome PLANTTOPIA_RIVER = new PlantTopiaRiverBiome();

    public static void registerBiomes() {
        ModBiomes.registerBiome(PLANTTOPIA_PLAINS, "planttopia_plains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiome(PLANTTOPIA_FOREST, "planttopia_forest", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(PLANTTOPIA_RIVER, "planttopia_river", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.RIVER);
    }

    private static Biome registerBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... type) {
        biome.setRegistryName(new ResourceLocation("planttech2", name));
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])type);
        return biome;
    }
}

