/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.datapack.CropListEntryConfiguration;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CropConfigChangeMessage {
    private Map<String, CropListEntryConfiguration> user_configs;

    public CropConfigChangeMessage(Map<String, CropListEntryConfiguration> user_configs) {
        this.user_configs = user_configs;
    }

    public static void encode(CropConfigChangeMessage pkt, PacketBuffer buf) {
        buf.func_150787_b(pkt.user_configs.size());
        for (Map.Entry<String, CropListEntryConfiguration> entry : pkt.user_configs.entrySet()) {
            buf.func_180714_a(entry.getKey());
            CropListEntryConfiguration.Deserializer.write(buf, entry.getValue());
        }
    }

    public static CropConfigChangeMessage decode(PacketBuffer buf) {
        HashMap<String, CropListEntryConfiguration> new_configs = new HashMap<String, CropListEntryConfiguration>();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            String name = buf.func_150789_c(1024);
            new_configs.put(name, CropListEntryConfiguration.Deserializer.read(name, buf));
        }
        return new CropConfigChangeMessage(new_configs);
    }

    public static class CropConfigChangeHandler {
        public static void handle(CropConfigChangeMessage pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                PlantTechMain.LOGGER.info("Sync crop configurations");
                for (CropListEntryConfiguration config : pkt.user_configs.values()) {
                    config.applyToEntry();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

