/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.items.upgradeable.UpgradeableHandItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;

public class MultitoolItem
extends UpgradeableHandItem {
    private static final Set<Block> EFFECTIVE_ON_SPADE = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh});
    private static final Set<Block> EFFECTIVE_ON_PICKAXE = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au});
    private static final Set<Block> EFFECTIVE_ON_AXE = Sets.newHashSet((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_196664_o, Blocks.field_196666_p, Blocks.field_196668_q, Blocks.field_196670_r, Blocks.field_196672_s, Blocks.field_150342_X, Blocks.field_196626_Q, Blocks.field_196629_R, Blocks.field_196631_S, Blocks.field_196634_T, Blocks.field_196637_U, Blocks.field_196639_V, Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_196625_cS, Blocks.field_196628_cT, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_196663_cq, Blocks.field_196665_cr, Blocks.field_196667_cs, Blocks.field_196669_ct, Blocks.field_196673_cv, Blocks.field_196671_cu});
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).build();
    protected static final Map<Block, BlockState> PATH_MAP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));
    protected static final Map<Block, BlockState> FARMLAND_MAP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    protected static final Set<Material> MATERIAL_EFFECT_ON = Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151575_d, Material.field_151585_k});

    public MultitoolItem() {
        super("multitool", new Item.Properties().func_200916_a(ModCreativeTabs.groupToolsAndArmor), 10000, 10, 2.0f, 2.4f, UpgradeChipItem.TOOL);
        this.func_185043_a(new ResourceLocation("drilling"), (stack, world, player) -> {
            if (player == null) {
                return 0.0f;
            }
            if (!(stack.func_77973_b() instanceof MultitoolItem)) {
                return 0.0f;
            }
            return player.field_70173_aa % 4 + 1;
        });
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        if (this.extractEnergy(stack, MultitoolItem.getEnergyCost(stack), true) >= MultitoolItem.getEnergyCost(stack)) {
            Block block = state.func_177230_c();
            int i = this.getHarvestLevel(stack);
            if (state.getHarvestTool() == ToolType.PICKAXE) {
                return i >= state.getHarvestLevel();
            }
            Material material = state.func_185904_a();
            return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC || block.getBlock() == Blocks.field_196553_aF;
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.extractEnergy(stack, MultitoolItem.getEnergyCost(stack), true) >= MultitoolItem.getEnergyCost(stack)) {
            Material material = state.func_185904_a();
            if (EFFECTIVE_ON_AXE.contains(state.func_177230_c()) || EFFECTIVE_ON_PICKAXE.contains(state.func_177230_c()) || EFFECTIVE_ON_SPADE.contains(state.func_177230_c())) {
                return this.getEfficiency(stack);
            }
            if (state.func_177230_c() == Blocks.field_196553_aF) {
                return 15.0f;
            }
            return !MATERIAL_EFFECT_ON.contains(material) ? super.func_150893_a(stack, state) : this.getEfficiency(stack);
        }
        return super.func_150893_a(stack, state);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (this.extractEnergy(ctx.func_195996_i(), MultitoolItem.getEnergyCost(ctx.func_195996_i()), true) >= MultitoolItem.getEnergyCost(ctx.func_195996_i())) {
            World world = ctx.func_195991_k();
            BlockPos blockpos = ctx.func_195995_a();
            BlockState state = world.func_180495_p(blockpos);
            BlockState state_for_spade = PATH_MAP.get(world.func_180495_p(blockpos).func_177230_c());
            BlockState state_for_hoe = FARMLAND_MAP.get(world.func_180495_p(blockpos).func_177230_c());
            Block block_for_strinping = BLOCK_STRIPPING_MAP.get(state.func_177230_c());
            PlayerEntity PlayerEntity2 = ctx.func_195999_j();
            if (ctx.func_196000_l() != Direction.DOWN && world.func_180495_p(blockpos.func_177984_a()).isAir((IBlockReader)world, blockpos.func_177984_a()) && state_for_spade != null) {
                if (NBTHelper.getBooleanSave(ctx.func_195996_i(), "unlockshovel", false)) {
                    world.func_184133_a(PlayerEntity2, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!world.field_72995_K) {
                        world.func_180501_a(blockpos, state_for_spade, 11);
                        if (PlayerEntity2 != null && !PlayerEntity2.func_184812_l_()) {
                            this.extractEnergy(ctx.func_195996_i(), MultitoolItem.getEnergyCost(ctx.func_195996_i()), false);
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (block_for_strinping != null) {
                if (NBTHelper.getBooleanSave(ctx.func_195996_i(), "unlockaxe", false)) {
                    world.func_184133_a(PlayerEntity2, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!world.field_72995_K) {
                        world.func_180501_a(blockpos, (BlockState)block_for_strinping.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, state.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                        if (PlayerEntity2 != null && !PlayerEntity2.func_184812_l_()) {
                            this.extractEnergy(ctx.func_195996_i(), MultitoolItem.getEnergyCost(ctx.func_195996_i()), false);
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (ctx.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && state_for_hoe != null && NBTHelper.getBooleanSave(ctx.func_195996_i(), "unlockhoe", false)) {
                world.func_184133_a(PlayerEntity2, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(blockpos, state_for_hoe, 11);
                    if (PlayerEntity2 != null && !PlayerEntity2.func_184812_l_()) {
                        this.extractEnergy(ctx.func_195996_i(), MultitoolItem.getEnergyCost(ctx.func_195996_i()), false);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public int getHarvestLevel(ItemStack stack) {
        return NBTHelper.getIntSave(stack, "harvestlevel", 0);
    }

    public float getEfficiency(ItemStack stack) {
        return Math.min(NBTHelper.getFloatSave(stack, "breakdownrate", 4), UpgradeChipItem.getBreakdownRateMax());
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (NBTHelper.getBooleanSave(stack, "unlockshears", false) && entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(stack, (IWorldReader)entity.field_70170_p, pos)) {
                List drops = target.onSheared(stack, (IWorld)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                Random rand = new Random();
                for (ItemStack drop : drops) {
                    ItemEntity ent = entity.func_70099_a(drop, 1.0f);
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
                this.extractEnergy(stack, MultitoolItem.getEnergyCost(stack), false);
            }
            return true;
        }
        return false;
    }
}

