/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryEnergyProvider
implements ICapabilitySerializable<CompoundNBT> {
    protected BioEnergyStorage energystorage;
    private LazyOptional<IEnergyStorage> energyCap;
    protected ItemStackHandler itemhandler;
    private LazyOptional<IItemHandler> inventoryCap;

    public InventoryEnergyProvider(int storage, int invSize) {
        this.energystorage = new BioEnergyStorage(storage);
        this.energystorage.setEnergyStored(storage);
        this.energyCap = LazyOptional.of(() -> this.energystorage);
        this.itemhandler = new ItemStackHandler(invSize);
        this.inventoryCap = LazyOptional.of(() -> this.itemhandler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("inventory", (INBT)this.itemhandler.serializeNBT());
        compound.func_218657_a("energy", (INBT)this.energystorage.serializeNBT());
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.itemhandler.deserializeNBT(nbt.func_74775_l("inventory"));
        this.energystorage.deserializeNBT(nbt.func_74775_l("energy"));
    }
}

