/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.container.entities.TechVillagerContainer;
import net.kaneka.planttech2.entities.capabilities.techvillagertrust.ITechVillagerTrust;
import net.kaneka.planttech2.entities.capabilities.techvillagertrust.TechVillagerTrust;
import net.kaneka.planttech2.entities.passive.TechVillagerEntity;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTask;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTrade;
import net.kaneka.planttech2.packets.DoTechVillagerTaskMessage;
import net.kaneka.planttech2.packets.DoTechVillagerTradeMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PlayerInventoryUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.IEnergyStorage;

public class TechVillagerScreen
extends ContainerScreen<TechVillagerContainer> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("planttech2:textures/gui/container/techvillager.png");
    protected final PlayerInventory player;
    protected int invsize;
    protected IEnergyStorage energystorage;
    protected TechVillagerTrade selectedTrade = null;
    protected TechVillagerTask selectedTask = null;
    protected int selectedID = -1;
    protected List<String> canTradeStrings = new ArrayList<String>();
    private String profession = "scientist";
    private String professionname = "loading";
    private int playertrustlevel = 0;

    public TechVillagerScreen(TechVillagerContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.player = inv;
    }

    public void init() {
        super.init();
        this.field_146999_f = 442;
        this.field_147000_g = 196;
        this.field_147003_i = (this.width - this.field_146999_f) / 2;
        this.field_147009_r = (this.height - this.field_147000_g) / 2;
        this.canTradeStrings = this.getCanTradeStrings();
        this.profession = TechVillagerEntity.getProfessionString(((TechVillagerContainer)this.field_147002_h).getProfession());
        this.professionname = new TranslationTextComponent("techvillager.profession." + TechVillagerEntity.getProfessionString(((TechVillagerContainer)this.field_147002_h).getProfession()), new Object[0]).func_150261_e();
        this.checkPlayerTrustLevel();
    }

    private void checkPlayerTrustLevel() {
        ITechVillagerTrust trust = (ITechVillagerTrust)this.player.field_70458_d.getCapability(TechVillagerTrust.INSTANCE).orElse(null);
        if (trust != null) {
            this.playertrustlevel = trust.getLevel(this.profession);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.checkPlayerTrustLevel();
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.renderSelectedTrades();
        this.func_191948_b(mouseX, mouseY);
        this.renderTooltips(mouseX, mouseY);
    }

    protected void renderSelectedTrades() {
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        if (this.selectedTrade != null) {
            int i;
            for (i = 0; i < this.selectedTrade.getInputs().size(); ++i) {
                this.renderItem(this.selectedTrade.getInputs().get(i), 147 + i % 3 * 18, 71 + i / 3 * 18);
            }
            for (i = 0; i < this.selectedTrade.getOutputs().size(); ++i) {
                this.renderItem(this.selectedTrade.getOutputs().get(i), 255 + i % 3 * 18, 71 + i / 3 * 18);
            }
        } else if (this.selectedTask != null) {
            for (int i = 0; i < this.selectedTask.getInputs().size(); ++i) {
                this.renderItem(this.selectedTask.getInputs().get(i), 147 + i % 2 * 18, 53 + i / 2 * 18);
            }
        }
        RenderHelper.func_74519_b();
    }

    public void renderTooltips(int mouseX, int mouseY) {
        ITechVillagerTrust trust;
        if (this.canTradeStrings.size() > 0) {
            if (this.selectedTrade != null) {
                this.drawTooltip(this.canTradeStrings, mouseX, mouseY, 202, 87, 50, 20);
            } else if (this.selectedTask != null) {
                this.drawTooltip(this.canTradeStrings, mouseX, mouseY, 185, 87, 50, 20);
            }
        }
        if ((trust = (ITechVillagerTrust)this.player.field_70458_d.getCapability(TechVillagerTrust.INSTANCE).orElse(null)) != null) {
            int level = trust.getLevel(this.profession);
            if (level < trust.getMaxLevel()) {
                float trustbefore = trust.getLevelTrust(level);
                float trustatm = (float)trust.getTrust(this.profession) - trustbefore;
                float trustneeded = (float)trust.getLevelTrust(level + 1) - trustbefore;
                this.drawTooltip((int)trustatm + "/" + (int)trustneeded + " Trust", mouseX, mouseY, 141, 23, 172, 2);
            } else {
                this.drawTooltip("MAX", mouseX, mouseY, 141, 23, 172, 2);
            }
        }
    }

    public void drawTooltip(List<String> lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            this.renderTooltip(lines, mouseX, mouseY);
        }
    }

    public void drawTooltip(String line, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            this.renderTooltip(line, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String color;
        int i;
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.professionname, (float)(this.field_146999_f / 2 - this.font.func_78256_a(this.professionname) / 2), 10.0f, Integer.parseInt("00e803", 16));
        this.font.func_211126_b("Trades", 70.0f, 14.0f, Integer.parseInt("00e803", 16));
        this.font.func_211126_b("Jobs", 354.0f, 14.0f, Integer.parseInt("00e803", 16));
        this.font.func_211126_b(String.valueOf(this.playertrustlevel), 140.0f, 20.0f, Integer.parseInt("00e803", 16));
        this.font.func_211126_b(String.valueOf(this.playertrustlevel + 1), 309.0f, 20.0f, Integer.parseInt("00e803", 16));
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTrades().size(); ++i) {
            color = "00e803";
            if (((TechVillagerContainer)this.field_147002_h).getTrades().get(i).getNeededLevel() > this.playertrustlevel) {
                color = "000000";
            }
            this.font.func_211126_b(((TechVillagerContainer)this.field_147002_h).getTrades().get(i).getName(), 43.0f, (float)(32 + i * 20), Integer.parseInt(color, 16));
        }
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTasks().size(); ++i) {
            color = "00e803";
            if (((TechVillagerContainer)this.field_147002_h).getTasks().get(i).getMinTrustLevel() > this.playertrustlevel) {
                color = "000000";
            }
            this.font.func_211126_b(((TechVillagerContainer)this.field_147002_h).getTasks().get(i).getName(), 321.0f, (float)(32 + i * 20), Integer.parseInt(color, 16));
        }
        if (this.selectedTrade != null) {
            String color2 = "00e803";
            if (this.selectedTrade.getNeededLevel() > this.playertrustlevel) {
                color2 = "000000";
            }
            this.font.func_211126_b("Trade", 212.0f, 93.0f, Integer.parseInt(color2, 16));
            this.font.func_211126_b(String.valueOf(this.selectedTrade.getCreditsBuy()), (float)(193 - String.valueOf(this.selectedTrade.getCreditsBuy()).length() * 6), 61.0f, Integer.parseInt("00e803", 16));
            this.font.func_211126_b(String.valueOf(this.selectedTrade.getCreditsSell()), (float)(301 - String.valueOf(this.selectedTrade.getCreditsSell()).length() * 6), 61.0f, Integer.parseInt("00e803", 16));
        } else if (this.selectedTask != null) {
            String color3 = "00e803";
            if (this.selectedTask.getMinTrustLevel() > this.playertrustlevel) {
                color3 = "000000";
            }
            this.font.func_211126_b("Trade", 194.0f, 93.0f, Integer.parseInt(color3, 16));
            this.font.func_211126_b(String.valueOf(this.selectedTask.getTrust()) + " Trust", (float)(317 - String.valueOf(this.selectedTask.getTrust() + " Trust").length() * 6), 78.0f, Integer.parseInt("00e803", 16));
        } else {
            this.font.func_211126_b("Maybe some kind of intoduction?", 142.0f, 30.0f, Integer.parseInt("00e803", 16));
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int k;
        int k2;
        int i;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        TechVillagerScreen.blit((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)512, (int)512);
        int trust = this.getTrustScaled(172);
        TechVillagerScreen.blit((int)(this.field_147003_i + 141), (int)(this.field_147009_r + 23), (float)225.0f, (float)197.0f, (int)trust, (int)2, (int)512, (int)512);
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTrades().size(); ++i) {
            int n = k2 = this.inArea(mouseX, mouseY, 39, 25 + i * 20, 98, 20) ? 1 : 0;
            if (this.selectedTrade != null && i == this.selectedID) {
                k2 = 1;
            }
            if (((TechVillagerContainer)this.field_147002_h).getTrades().get(i).getNeededLevel() > this.playertrustlevel) {
                k2 = i == this.selectedID && this.selectedTrade != null || k2 == 1 ? 3 : 2;
            }
            TechVillagerScreen.blit((int)(this.field_147003_i + 39), (int)(this.field_147009_r + 25 + i * 20), (float)0.0f, (float)(197 + 20 * k2), (int)98, (int)20, (int)512, (int)512);
        }
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTasks().size(); ++i) {
            int n = k2 = this.inArea(mouseX, mouseY, 317, 25 + i * 20, 98, 20) ? 1 : 0;
            if (this.selectedTask != null && i == this.selectedID) {
                k2 = 1;
            }
            if (((TechVillagerContainer)this.field_147002_h).getTasks().get(i).getMinTrustLevel() > this.playertrustlevel) {
                k2 = i == this.selectedID && this.selectedTask != null || k2 == 1 ? 3 : 2;
            }
            TechVillagerScreen.blit((int)(this.field_147003_i + 317), (int)(this.field_147009_r + 25 + i * 20), (float)0.0f, (float)(197 + 20 * k2), (int)98, (int)20, (int)512, (int)512);
        }
        if (this.selectedTrade != null) {
            int n = k = this.inArea(mouseX, mouseY, 203, 87, 48, 20) ? 1 : 0;
            if (this.selectedTrade.getNeededLevel() > this.playertrustlevel) {
                k = k == 1 ? 3 : 2;
            }
            TechVillagerScreen.blit((int)(this.field_147003_i + 203), (int)(this.field_147009_r + 87), (float)98.0f, (float)(197 + 20 * k), (int)48, (int)20, (int)512, (int)512);
            TechVillagerScreen.blit((int)(this.field_147003_i + 145), (int)(this.field_147009_r + 59), (float)450.0f, (float)0.0f, (int)56, (int)48, (int)512, (int)512);
            TechVillagerScreen.blit((int)(this.field_147003_i + 253), (int)(this.field_147009_r + 59), (float)450.0f, (float)0.0f, (int)56, (int)48, (int)512, (int)512);
            TechVillagerScreen.blit((int)(this.field_147003_i + 203), (int)(this.field_147009_r + 76), (float)450.0f, (float)59.0f, (int)48, (int)9, (int)512, (int)512);
        } else if (this.selectedTask != null) {
            int n = k = this.inArea(mouseX, mouseY, 185, 87, 48, 20) ? 1 : 0;
            if (this.selectedTask.getMinTrustLevel() > this.playertrustlevel || this.selectedTask.getMaxTrustLevel() < this.playertrustlevel) {
                k = k == 1 ? 3 : 2;
            }
            TechVillagerScreen.blit((int)(this.field_147003_i + 185), (int)(this.field_147009_r + 87), (float)98.0f, (float)(197 + 20 * k), (int)48, (int)20, (int)512, (int)512);
            TechVillagerScreen.blit((int)(this.field_147003_i + 145), (int)(this.field_147009_r + 51), (float)450.0f, (float)68.0f, (int)38, (int)56, (int)512, (int)512);
            TechVillagerScreen.blit((int)(this.field_147003_i + 185), (int)(this.field_147009_r + 76), (float)450.0f, (float)59.0f, (int)48, (int)9, (int)512, (int)512);
            TechVillagerScreen.blit((int)(this.field_147003_i + 235), (int)(this.field_147009_r + 76), (float)146.0f, (float)197.0f, (int)79, (int)20, (int)512, (int)512);
        }
    }

    public void renderItem(ItemStack stack, int x, int y) {
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.blitOffset = 200;
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.font;
        }
        this.itemRenderer.func_180450_b(stack, this.field_147003_i + x, this.field_147009_r + y);
        this.itemRenderer.func_180453_a(font, stack, this.field_147003_i + x, this.field_147009_r + y, null);
        this.blitOffset = 0;
        this.itemRenderer.field_77023_b = 0.0f;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_mouseClicked_5_) {
        int i;
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTrades().size(); ++i) {
            if (!this.inArea(mouseX, mouseY, 39, 25 + i * 20, 98, 20)) continue;
            this.selectedTrade = ((TechVillagerContainer)this.field_147002_h).getTrades().get(i);
            this.selectedTask = null;
            this.selectedID = i;
        }
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTasks().size(); ++i) {
            if (!this.inArea(mouseX, mouseY, 317, 25 + i * 20, 98, 20)) continue;
            this.selectedTask = ((TechVillagerContainer)this.field_147002_h).getTasks().get(i);
            this.selectedTrade = null;
            this.selectedID = i;
        }
        if (this.selectedTrade != null && this.inArea(mouseX, mouseY, 203, 76, 48, 20) && this.getCanTradeStrings().size() <= 0) {
            PlantTech2PacketHandler.sendToServer(new DoTechVillagerTradeMessage(this.selectedTrade, ((TechVillagerContainer)this.field_147002_h).getProfession()));
        }
        if (this.selectedTask != null && this.inArea(mouseX, mouseY, 185, 87, 50, 20) && this.getCanTradeStrings().size() <= 0) {
            PlantTech2PacketHandler.sendToServer(new DoTechVillagerTaskMessage(this.selectedTask.getID()));
        }
        this.canTradeStrings = this.getCanTradeStrings();
        this.checkPlayerTrustLevel();
        return super.mouseClicked(mouseX, mouseY, p_mouseClicked_5_);
    }

    private boolean inArea(double mouseX, double mouseY, int startX, int startY, int width, int height) {
        return mouseX >= (double)(startX += this.field_147003_i) && mouseX <= (double)(startX + width) && mouseY >= (double)(startY += this.field_147009_r) && mouseY <= (double)(startY + height);
    }

    public List<String> getCanTradeStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.selectedTrade != null) {
            if (this.selectedTrade.getNeededLevel() <= this.playertrustlevel) {
                if (PlayerInventoryUtils.enoughSpace(this.player, this.selectedTrade.getOutputs().size())) {
                    if (PlayerInventoryUtils.hasList(this.player, this.selectedTrade.getInputs())) {
                        if (PlayerInventoryUtils.enoughCredits(this.player, this.selectedTrade.getCreditsBuy())) {
                            if ((this.selectedTrade.getCreditsSell() <= 0 || this.player.func_213901_a((Item)ModItems.PLANTCARD) <= 0) && this.selectedTrade.getCreditsSell() > 0) {
                                list.add("No plantcard in inventory");
                            }
                        } else {
                            list.add("Not enough credits");
                        }
                    } else {
                        list.add("Not enough items");
                    }
                } else {
                    list.add("Not enough space");
                }
            } else {
                list.add("Not enough trust");
            }
        } else if (this.selectedTask != null) {
            if (PlayerInventoryUtils.hasList(this.player, this.selectedTask.getInputs())) {
                if (this.playertrustlevel >= this.selectedTask.getMinTrustLevel()) {
                    if (this.playertrustlevel > this.selectedTask.getMaxTrustLevel()) {
                        list.add("To much Trust");
                    }
                } else {
                    list.add("Not enough Trust");
                }
            } else {
                list.add("Not enough items");
            }
        } else {
            list.add("No trade selected");
        }
        return list;
    }

    private int getTrustScaled(int pixel) {
        ITechVillagerTrust trust = (ITechVillagerTrust)this.player.field_70458_d.getCapability(TechVillagerTrust.INSTANCE).orElse(null);
        if (trust != null) {
            int level = trust.getLevel(this.profession);
            if (level < trust.getMaxLevel()) {
                float trustbefore = trust.getLevelTrust(level);
                float trustatm = (float)trust.getTrust(this.profession) - trustbefore;
                float trustneeded = (float)trust.getLevelTrust(level + 1) - trustbefore;
                return (int)(trustatm / trustneeded * (float)pixel);
            }
            return pixel;
        }
        return 0;
    }
}

