/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.gui.GuideBaseScreen;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.minecraft.client.gui.widget.Widget;

public class GuideGeneticEngineeringScreen
extends GuideBaseScreen {
    private String[] keys = new String[6];
    List<String> lines = new ArrayList<String>();
    private double charsPerLine = 40.0;
    private double linesPerSite = 14.0;
    private int site = 0;
    private int maxSites = 1;

    public GuideGeneticEngineeringScreen() {
        super(-2, false, "screen.guidegeneticentineering");
    }

    @Override
    public void init() {
        super.init();
        this.addButton((Widget)new CustomButton(0, this.guiLeft + 28, this.guiTop + 10 + 0, 100, 20, "TEST", button -> this.buttonClicked(0)));
        this.addButton((Widget)new CustomButton(1, this.guiLeft + 28, this.guiTop + 10 + 22, 100, 20, "TEST", button -> this.buttonClicked(1)));
        this.addButton((Widget)new CustomButton(2, this.guiLeft + 28, this.guiTop + 10 + 44, 100, 20, "TEST", button -> this.buttonClicked(2)));
        this.addButton((Widget)new CustomButton(3, this.guiLeft + 28, this.guiTop + 10 + 66, 100, 20, "TEST", button -> this.buttonClicked(3)));
        this.addButton((Widget)new CustomButton(4, this.guiLeft + 28, this.guiTop + 10 + 88, 100, 20, "TEST", button -> this.buttonClicked(4)));
        this.addButton((Widget)new CustomButton(5, this.guiLeft + 28, this.guiTop + 10 + 110, 100, 20, "TEST", button -> this.buttonClicked(5)));
        this.addButton((Widget)new CustomButton(6, this.guiLeft + 28, this.guiTop + 10 + 132, 100, 20, "TEST", button -> this.buttonClicked(6)));
        this.addButton((Widget)new CustomButton(7, this.guiLeft + 28, this.guiTop + 10 + 154, 100, 20, "TEST", button -> this.buttonClicked(7)));
        this.buttons.add(new CustomButton(8, this.guiLeft + 150, this.guiTop + 170, 100, 20, this.translateUnformated("gui.last"), button -> this.buttonClicked(8)));
        this.buttons.add(new CustomButton(9, this.guiLeft + 285, this.guiTop + 170, 100, 20, this.translateUnformated("gui.next"), button -> this.buttonClicked(9)));
        ((Widget)this.buttons.get((int)8)).active = false;
        ((Widget)this.buttons.get((int)8)).visible = false;
        ((Widget)this.buttons.get((int)9)).active = false;
        ((Widget)this.buttons.get((int)9)).visible = false;
        this.keys[0] = "ge_start";
        this.keys[1] = "ge_extracting";
        this.keys[2] = "ge_removing";
        this.keys[3] = "ge_combining";
        this.keys[4] = "ge_cleaning";
        this.keys[5] = "ge_creating";
        this.updateButtons();
    }

    protected void buttonClicked(int button) {
        if (button >= 0 && button < 8) {
            this.selectedId = button + this.scrollPos;
            this.convertString(this.translateUnformated("guide." + this.keys[this.selectedId] + ".text"));
        } else if (button == 8) {
            if (this.site > 0) {
                --this.site;
                ((Widget)this.buttons.get((int)9)).active = true;
                ((Widget)this.buttons.get((int)9)).visible = true;
                if (this.site == 0) {
                    ((Widget)this.buttons.get((int)8)).active = false;
                    ((Widget)this.buttons.get((int)8)).visible = false;
                }
            }
        } else if (button == 9 && this.site < this.maxSites - 1) {
            ++this.site;
            ((Widget)this.buttons.get((int)8)).active = true;
            ((Widget)this.buttons.get((int)8)).visible = true;
            if (this.site == this.maxSites) {
                ((Widget)this.buttons.get((int)9)).active = false;
                ((Widget)this.buttons.get((int)9)).visible = false;
            }
        }
    }

    @Override
    protected void drawStrings() {
        if (this.selectedId == -1) {
            this.drawCenteredString(this.translateUnformated("gui.non_selected"), this.guiLeft + 255, this.guiTop + 90);
        } else {
            this.drawCenteredString(this.translateUnformated("guide." + this.keys[this.selectedId] + ".header"), this.guiLeft + 260, this.guiTop + 10);
            int i = 0;
            while ((double)i < this.linesPerSite) {
                if ((double)this.lines.size() > (double)i + (double)this.site * this.linesPerSite) {
                    this.drawLine(this.lines.get((int)((double)i + (double)this.site * this.linesPerSite)), this.guiLeft + 160, this.guiTop + 25 + 10 * i);
                }
                ++i;
            }
        }
    }

    protected void drawLine(String text, int x, int y) {
        this.font.func_211126_b(text, (float)x, (float)y, Integer.parseInt("00e803", 16));
    }

    protected void convertString(String string) {
        String[] array = string.split("=nl");
        this.lines.clear();
        String combined = "";
        int charcounter = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length() > 0) {
                if (Math.ceil((double)array[i].length() / this.charsPerLine) > 1.0) {
                    String[] array2 = array[i].split("\\s+");
                    combined = "";
                    charcounter = 0;
                    for (int k = 0; k < array2.length; ++k) {
                        if ((double)(array2[k].length() + charcounter) > this.charsPerLine) {
                            this.lines.add(combined);
                            combined = array2[k] + " ";
                            charcounter = array2[k].length() + 1;
                            continue;
                        }
                        combined = combined + array2[k] + " ";
                        charcounter += array2[k].length() + 1;
                    }
                    this.lines.add(combined);
                    continue;
                }
                this.lines.add(array[i]);
                continue;
            }
            this.lines.add("");
        }
        this.site = 0;
        this.maxSites = (int)Math.ceil((double)this.lines.size() / this.linesPerSite);
        ((Widget)this.buttons.get((int)8)).active = false;
        ((Widget)this.buttons.get((int)8)).visible = false;
        if (this.maxSites > 1) {
            ((Widget)this.buttons.get((int)9)).active = true;
            ((Widget)this.buttons.get((int)9)).visible = true;
        } else {
            ((Widget)this.buttons.get((int)9)).active = false;
            ((Widget)this.buttons.get((int)9)).visible = false;
        }
    }

    @Override
    protected void updateButtons() {
        for (int i = 0; i < 8; ++i) {
            if (this.keys.length > i) {
                ((Widget)this.buttons.get((int)i)).visible = true;
                ((Widget)this.buttons.get((int)i)).active = true;
                ((Widget)this.buttons.get(i)).setMessage(this.translateUnformated("guide." + this.keys[this.scrollPos + i] + ".header"));
                continue;
            }
            ((Widget)this.buttons.get((int)i)).visible = false;
            ((Widget)this.buttons.get((int)i)).active = false;
        }
    }

    @Override
    protected void drawCenteredString(String string, int posX, int posY) {
        this.font.func_211126_b(string, (float)(posX - this.font.func_78256_a(string) / 2), (float)posY, Integer.parseInt("00e803", 16));
    }
}

