/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.filehelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.kaneka.planttech2.librarys.utils.Drop;
import net.kaneka.planttech2.librarys.utils.Parents;
import net.minecraft.item.ItemStack;

public class CropListJSONGenerator {
    int maxLines = 500;
    int nextLine = 0;
    String[] lines = new String[this.maxLines];
    HashMap<String, String> colors = new HashMap();
    HashMap<String, Boolean> hasParticle = new HashMap();

    private void saveFile(String file) {
        try {
            File f = new File("json/" + file + ".json");
            f.createNewFile();
            FileWriter fw = new FileWriter(f, true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.nextLine; ++i) {
                bw.write(this.lines[i]);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lines = new String[this.maxLines];
        this.nextLine = 0;
    }

    private void addLine(String line) {
        this.lines[this.nextLine] = line;
        ++this.nextLine;
    }

    private void createBlockstateFile(String name) {
        this.addLine("{");
        this.addLine("    \"variants\": {");
        this.addLine("        \"growstate=0\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_0\"");
        this.addLine("       },");
        this.addLine("       \"growstate=1\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_1\"");
        this.addLine("        },");
        this.addLine("        \"growstate=2\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_2\"");
        this.addLine("        },");
        this.addLine("       \"growstate=3\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_3\"");
        this.addLine("       },");
        this.addLine("       \"growstate=4\": {");
        this.addLine("           \"model\": \"planttech2:block/crop_4\"");
        this.addLine("       },");
        this.addLine("     \"growstate=5\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_5\"");
        this.addLine("        },");
        this.addLine("        \"growstate=6\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_6\"");
        this.addLine("        },");
        this.addLine("        \"growstate=7\": {");
        this.addLine("            \"model\": \"planttech2:block/crop_7\"");
        this.addLine("        }");
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(name + "_crop");
    }

    /*
     * WARNING - void declaration
     */
    private void createConfigJSON(CropListEntry entry) {
        this.addLine("{");
        this.addLine("    \"enabled\": " + !entry.isBlacklisted() + ",");
        this.addLine("    \"temperature\": " + entry.getTemperature().getId() + ",");
        this.addLine("    \"seeds\": [");
        List<ItemStack> seeds = entry.getSeeds();
        int i = 0;
        if (seeds != null) {
            for (ItemStack itemStack : seeds) {
                void var6_9;
                String string = "        \"" + itemStack.func_77973_b().getRegistryName() + "\"";
                if (i < seeds.size() - 1) {
                    String string2 = string + ",";
                }
                this.addLine((String)var6_9);
                ++i;
            }
        }
        this.addLine("    ],");
        this.addLine("    \"drops\":[");
        Set<Drop> add_drops = entry.getDrops();
        i = 0;
        if (add_drops != null) {
            for (Drop drop : add_drops) {
                this.addLine("        {");
                this.addLine("            \"item\": \"" + drop.getItemStack().func_77973_b().getRegistryName() + "\",");
                this.addLine("            \"min\": " + drop.getMin() + ", ");
                this.addLine("            \"max\": " + drop.getMax());
                String string = "        }";
                if (i < add_drops.size() - 1) {
                    string = string + ",";
                }
                this.addLine(string);
                ++i;
            }
        }
        this.addLine("    ],");
        this.addLine("    \"parents\": [");
        Set<Parents> set = entry.getParents();
        i = 0;
        if (set != null) {
            for (Parents parent_pair : set) {
                this.addLine("        {");
                this.addLine("            \"partner_1\": \"" + parent_pair.getParent(0) + "\",");
                this.addLine("            \"partner_2\": \"" + parent_pair.getParent(1) + "\", ");
                this.addLine("            \"chance\": " + parent_pair.getMutateChance());
                String string = "        }";
                if (i < set.size() - 1) {
                    string = string + ",";
                }
                this.addLine(string);
                ++i;
            }
        }
        this.addLine("    ],");
        this.addLine("    \"soil\": ");
        this.addLine("    {");
        ItemStack itemStack = entry.getSoil();
        if (!itemStack.func_190926_b()) {
            this.addLine("        \"block\": \"" + itemStack.func_77973_b().getRegistryName() + "\"");
        }
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(entry.getString());
    }

    private void addEntry(String name, String color, boolean hasParticle) {
        this.colors.put(name, color);
        this.hasParticle.put(name, hasParticle);
    }

    public void createFiles() {
        this.addEntry("allium", "a65ee1", false);
        this.addEntry("aluminum", "b4b4b4", true);
        this.addEntry("ardite", "88471b", true);
        this.addEntry("azure_bluet", "d6e8e8", false);
        this.addEntry("beast", "6a6965", true);
        this.addEntry("beetroots", "bf2529", false);
        this.addEntry("black_quartz", "202020", true);
        this.addEntry("blaze", "fc9600", true);
        this.addEntry("blue_orchid", "1c92d6", false);
        this.addEntry("cactus", "527d26", false);
        this.addEntry("carrot", "e38a1d", false);
        this.addEntry("chicken", "e2e2e2", true);
        this.addEntry("certus_quartz", "36a3a3", true);
        this.addEntry("chorus", "8f718f", false);
        this.addEntry("coal", "3f3f3f", true);
        this.addEntry("cobalt", "1d5791", true);
        this.addEntry("cocoa_bean", "b97335", false);
        this.addEntry("copper", "b47800", true);
        this.addEntry("cornflower", "466aeb", false);
        this.addEntry("cow", "443626", true);
        this.addEntry("creeper", "41b736", true);
        this.addEntry("dancium", "eb8c14", true);
        this.addEntry("dandelion", "fed639", false);
        this.addEntry("diamond", "77cefb", true);
        this.addEntry("dirt", "593d29", true);
        this.addEntry("drowned", "8ff1d7", true);
        this.addEntry("emerald", "17dd62", true);
        this.addEntry("enderdragon", "181818", true);
        this.addEntry("enderman", "181818", true);
        this.addEntry("endstone", "f6fabd", true);
        this.addEntry("fish", "bf841b", true);
        this.addEntry("ghast", "f0f0f0", true);
        this.addEntry("glowstone", "fbda74", true);
        this.addEntry("gold", "f8af2b", true);
        this.addEntry("guardian", "668980", true);
        this.addEntry("husk", "6a5d4a", true);
        this.addEntry("illager", "939999", true);
        this.addEntry("iron", "bc9980", true);
        this.addEntry("kanekium", "572e8a", true);
        this.addEntry("kinnoium", "246b2d", true);
        this.addEntry("lilly_of_the_valley", "e7e7e7", false);
        this.addEntry("lapis", "1044ac", true);
        this.addEntry("lava", "d14f0c", true);
        this.addEntry("lead", "326e99", true);
        this.addEntry("lenthurium", "2c8585", true);
        this.addEntry("magma_cube", "330000", true);
        this.addEntry("melon", "a7ac1d", false);
        this.addEntry("mooshroom", "a81012", true);
        this.addEntry("mushroom", "e21212", false);
        this.addEntry("mycelium", "736162", true);
        this.addEntry("netherrack", "652828", true);
        this.addEntry("nether_wart", "831c20", false);
        this.addEntry("nickel", "aeaf3a", true);
        this.addEntry("orange_tulip", "bd6a22", false);
        this.addEntry("oxeye_daisy", "f5ba27", false);
        this.addEntry("panda", "f5ba27", true);
        this.addEntry("parrot", "18bdff", true);
        this.addEntry("pig", "f19e98", true);
        this.addEntry("pink_tulip", "e4aff4", false);
        this.addEntry("plantium", "35a048", true);
        this.addEntry("platinum", "a2a2a2", true);
        this.addEntry("polarbear", "f6f6f6", true);
        this.addEntry("poppy", "ed302c", false);
        this.addEntry("potato", "c8a24b", false);
        this.addEntry("prismarin", "5ea496", true);
        this.addEntry("pumpkin", "e38a1d", false);
        this.addEntry("quartz", "d4caba", true);
        this.addEntry("redstone", "ff0000", true);
        this.addEntry("red_tulip", "ed302c", false);
        this.addEntry("sand", "dacfa3", true);
        this.addEntry("sheep", "c09e86", true);
        this.addEntry("shulker", "8e608e", true);
        this.addEntry("silver", "dadada", true);
        this.addEntry("skeleton", "bcbcbc", true);
        this.addEntry("slime", "59bd45", true);
        this.addEntry("snow", "ffffff", true);
        this.addEntry("soulsand", "49372c", true);
        this.addEntry("spider", "605448", true);
        this.addEntry("sponge", "cdce4a", true);
        this.addEntry("squid", "cdce4a", true);
        this.addEntry("stone", "616161", true);
        this.addEntry("stray", "acbabd", true);
        this.addEntry("sugarcane", "82a859", false);
        this.addEntry("tin", "aba78c", true);
        this.addEntry("turtle", "388d3a", true);
        this.addEntry("uranium", "3abd22", true);
        this.addEntry("villager", "b57b67", true);
        this.addEntry("vine", "1b5011", false);
        this.addEntry("water", "2b5fff", true);
        this.addEntry("wheat", "ae19", false);
        this.addEntry("white_tulip", "f7f7f7", false);
        this.addEntry("witch", "a39483", true);
        this.addEntry("wither_rose", "0", false);
        this.addEntry("wither_skeleton", "515353", true);
        this.addEntry("wither", "343434", true);
        this.addEntry("wood", "605e54", true);
        this.addEntry("zombie_pigman", "eea5a4", true);
        this.addEntry("zombie_villager", "3b622f", true);
        this.addEntry("zombie", "71955b", true);
        this.addEntry("rubber", "FFFFFF", true);
        this.addEntry("silicon", "FFFFFF", true);
        this.addEntry("sulfur", "FFFFFF", true);
        this.addEntry("saltpeter", "FFFFFF", true);
        this.addEntry("bronze", "FFFFFF", true);
        this.addEntry("zinc", "FFFFFF", true);
        this.addEntry("brass_silver", "FFFFFF", true);
        this.addEntry("graphite", "FFFFFF", true);
        this.addEntry("steel", "FFFFFF", true);
        this.addEntry("nickel", "FFFFFF", true);
        this.addEntry("constantan", "FFFFFF", true);
        this.addEntry("electrum", "FFFFFF", true);
        this.addEntry("invar", "FFFFFF", true);
        this.addEntry("mithril", "FFFFFF", true);
        this.addEntry("tungsten", "FFFFFF", true);
        this.addEntry("titanium", "FFFFFF", true);
        this.addEntry("chrome", "FFFFFF", true);
        this.addEntry("iridium ", "FFFFFF", true);
        this.addEntry("ruby", "FFFFFF", true);
        this.addEntry("sapphire", "FFFFFF", true);
        this.addEntry("peridot", "FFFFFF", true);
        this.addEntry("amber", "FFFFFF", true);
        this.addEntry("topaz", "FFFFFF", true);
        this.addEntry("malachite", "FFFFFF", true);
        this.addEntry("tanzanite", "FFFFFF", true);
        this.addEntry("blizz", "FFFFFF", true);
        this.addEntry("blitz", "FFFFFF", true);
        this.addEntry("basalt", "FFFFFF", true);
        this.addEntry("signalum", "FFFFFF", true);
        this.addEntry("lumium", "FFFFFF", true);
        this.addEntry("enderium", "FFFFFF", true);
        this.addEntry("fluxed_electrum", "FFFFFF", true);
        this.addEntry("aluminum_brass", "FFFFFF", true);
        this.addEntry("knightslime", "FFFFFF", true);
        this.addEntry("manyullyn", "FFFFFF", true);
        this.addEntry("electrical_steel", "FFFFFF", true);
        this.addEntry("redstone_alloy", "FFFFFF", true);
        this.addEntry("conductive_iron", "FFFFFF", true);
        this.addEntry("soularium", "FFFFFF", true);
        this.addEntry("dark_steel", "FFFFFF", true);
        this.addEntry("pulsating_iron", "FFFFFF", true);
        this.addEntry("energetic_alloy", "FFFFFF", true);
        this.addEntry("vibrant_alloy", "FFFFFF", true);
        this.addEntry("end_steel", "FFFFFF", true);
        this.addEntry("manasteel", "FFFFFF", true);
        this.addEntry("elementium", "FFFFFF", true);
        this.addEntry("terrasteel", "FFFFFF", true);
        this.addEntry("quicksilver", "FFFFFF", true);
        this.addEntry("thaumium", "FFFFFF", true);
        this.addEntry("void_metal", "FFFFFF", true);
        this.addEntry("osmium", "FFFFFF", true);
        this.addEntry("glowstone_ingot", "FFFFFF", true);
        this.addEntry("refined_obsidian", "FFFFFF", true);
        this.addEntry("aquarium", "FFFFFF", true);
        this.addEntry("cold_iron", "FFFFFF", true);
        this.addEntry("star_steel", "FFFFFF", true);
        this.addEntry("adamantine", "FFFFFF", true);
        this.addEntry("apatite", "FFFFFF", true);
        this.addEntry("electrotine", "FFFFFF", true);
        this.addEntry("alumite", "FFFFFF", true);
        this.addEntry("meteoric_iron", "FFFFFF", true);
        this.addEntry("desh", "FFFFFF", true);
        this.addEntry("coralium", "FFFFFF", true);
        this.addEntry("abyssalnite", "FFFFFF", true);
        this.addEntry("dreadium", "FFFFFF", true);
        this.addEntry("slimy_bone", "FFFFFF", true);
        this.addEntry("syrmorite", "FFFFFF", true);
        this.addEntry("octine", "FFFFFF", true);
        this.addEntry("valonite", "FFFFFF", true);
        this.addEntry("thorium", "FFFFFF", true);
        this.addEntry("boron", "FFFFFF", true);
        this.addEntry("lithium", "FFFFFF", true);
        this.addEntry("magnesium", "FFFFFF", true);
        this.addEntry("vinteum", "FFFFFF", true);
        this.addEntry("chimerite", "FFFFFF", true);
        this.addEntry("blue_topaz", "FFFFFF", true);
        this.addEntry("moonstone", "FFFFFF", true);
        this.addEntry("sunstone", "FFFFFF", true);
        this.addEntry("aquamarine", "FFFFFF", true);
        this.addEntry("starmetal", "FFFFFF", true);
        this.addEntry("rock_crystal", "FFFFFF", true);
        this.addEntry("ender_biotite", "FFFFFF", true);
        this.addEntry("slate", "FFFFFF", true);
        this.addEntry("dark_gem", "FFFFFF", true);
        this.addEntry("compressed_iron", "FFFFFF", true);
        this.addEntry("ender_amethyst", "FFFFFF", true);
        this.addEntry("draconium", "FFFFFF", true);
        this.addEntry("yellorium", "FFFFFF", true);
        this.addEntry("sky_stone", "FFFFFF", true);
        this.addEntry("certus_quartz", "FFFFFF", true);
        this.addEntry("fluix", "FFFFFF", true);
        this.addEntry("quartz_enriched_iron", "FFFFFF", true);
        this.addEntry("awakened_draconium", "FFFFFF", true);
        this.addEntry("neutronium", "FFFFFF", true);
        for (String name : this.colors.keySet()) {
            this.createBlockstateFile(name);
        }
    }

    public void createConfigFiles() {
        for (CropListEntry entry : PlantTechMain.croplist.getAllEntries()) {
            this.createConfigJSON(entry);
        }
    }
}

