/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.tradesandjobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class TechVillagerTrade {
    private final String name;
    private final List<ItemStack> inputs;
    private final List<ItemStack> outputs;
    private final int creditsBuy;
    private final int creditsSell;
    private final int neededTrustLevel;

    public TechVillagerTrade(String name, List<ItemStack> inputs, List<ItemStack> outputs, int creditsBuy, int creditsSell, int neededTrustLevel) {
        this.name = name;
        this.inputs = inputs;
        this.outputs = outputs;
        this.creditsBuy = creditsBuy;
        this.creditsSell = creditsSell;
        this.neededTrustLevel = neededTrustLevel;
    }

    public String getName() {
        return new TranslationTextComponent(this.name, new Object[0]).func_150261_e();
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public int getCreditsBuy() {
        return this.creditsBuy;
    }

    public int getCreditsSell() {
        return this.creditsSell;
    }

    public int getNeededLevel() {
        return this.neededTrustLevel;
    }

    public CompoundNBT toNBT() {
        int i;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("length_inputs", this.inputs.size());
        for (i = 0; i < this.inputs.size(); ++i) {
            nbt.func_218657_a("input_" + i, (INBT)this.inputs.get(i).serializeNBT());
        }
        nbt.func_74768_a("length_outputs", this.outputs.size());
        for (i = 0; i < this.outputs.size(); ++i) {
            nbt.func_218657_a("output_" + i, (INBT)this.outputs.get(i).serializeNBT());
        }
        nbt.func_74768_a("creditsbuy", this.creditsBuy);
        nbt.func_74768_a("creditssell", this.creditsSell);
        nbt.func_74768_a("neededtrustlevel", this.neededTrustLevel);
        return nbt;
    }

    public static TechVillagerTrade fromNBT(CompoundNBT nbt) {
        int i;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (i = 0; i < nbt.func_74762_e("length_inputs"); ++i) {
            inputs.add(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("input_" + i)));
        }
        for (i = 0; i < nbt.func_74762_e("length_outputs"); ++i) {
            outputs.add(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("output_" + i)));
        }
        return new TechVillagerTrade(nbt.func_74779_i("name"), inputs, outputs, nbt.func_74762_e("creditsbuy"), nbt.func_74762_e("creditssell"), nbt.func_74762_e("neededtrustlevel"));
    }

    public PacketBuffer toBuffer(PacketBuffer buf) {
        int i;
        buf.func_180714_a(this.name);
        buf.writeInt(this.inputs.size());
        for (i = 0; i < this.inputs.size(); ++i) {
            buf.func_150788_a(this.inputs.get(i));
        }
        buf.writeInt(this.outputs.size());
        for (i = 0; i < this.outputs.size(); ++i) {
            buf.func_150788_a(this.outputs.get(i));
        }
        buf.writeInt(this.creditsBuy);
        buf.writeInt(this.creditsSell);
        buf.writeInt(this.neededTrustLevel);
        return buf;
    }

    public static TechVillagerTrade fromBuffer(PacketBuffer buf) {
        int i;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        String name = buf.func_218666_n();
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            inputs.add(buf.func_150791_c());
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            outputs.add(buf.func_150791_c());
        }
        return new TechVillagerTrade(name, inputs, outputs, buf.readInt(), buf.readInt(), buf.readInt());
    }
}

