/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.kaneka.planttech2.librarys.utils.Parents;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class CropListEntryConfiguration {
    private String croplistentry;
    private boolean enabled;
    private EnumTemperature temperature;
    private List<Item> seeds;
    private List<Triple<Item, Integer, Integer>> drops;
    private List<Parents> parents;
    private Block soil;

    public CropListEntryConfiguration(String croplistentry, boolean enabled, EnumTemperature temperature, List<Item> seeds, List<Triple<Item, Integer, Integer>> additional_drops, List<Parents> parents, Block soil) {
        this.croplistentry = croplistentry;
        this.enabled = enabled;
        this.temperature = temperature;
        this.seeds = seeds;
        this.drops = additional_drops;
        this.parents = parents;
        this.soil = soil;
    }

    public void applyToEntry() {
        CropListEntry entry = PlantTechMain.croplist.getEntryByName(this.croplistentry);
        if (entry != null) {
            entry.setBlacklisted(!this.enabled);
            if (this.temperature != null) {
                entry.alternateTemperature(this.temperature);
            }
            if (this.seeds != null) {
                entry.clearSeeds();
                for (Item item : this.seeds) {
                    entry.addSeeds(new ItemStack((IItemProvider)item));
                }
            }
            if (this.drops != null) {
                entry.clearDrops();
                for (Triple triple : this.drops) {
                    entry.addDrop(new ItemStack((IItemProvider)triple.getLeft()), (Integer)triple.getMiddle(), (Integer)triple.getRight());
                }
            }
            if (this.parents != null) {
                entry.clearParents();
                for (Parents parents : this.parents) {
                    entry.addParents(parents.getParent(0), parents.getParent(1), parents.getMutateChance());
                }
            }
            if (this.soil != null) {
                entry.setSoil(new ItemStack((IItemProvider)this.soil));
            } else {
                entry.setSoil(ItemStack.field_190927_a);
            }
        }
    }

    public void merge(CropListEntryConfiguration changes) {
        this.enabled = changes.enabled;
        if (changes.temperature != null) {
            this.temperature = changes.temperature;
        }
        if (changes.seeds != null) {
            this.seeds = changes.seeds;
        }
        if (changes.drops != null) {
            this.drops = changes.drops;
        }
        if (changes.parents != null) {
            this.parents = changes.parents;
        }
        if (changes.soil != null) {
            this.soil = changes.soil;
        }
    }

    public static class Deserializer {
        public static CropListEntryConfiguration read(String croplistentry, JsonObject jsonObject) {
            boolean enabled = true;
            if (jsonObject.has("enabled")) {
                enabled = jsonObject.get("enabled").getAsBoolean();
            }
            EnumTemperature temperature = null;
            if (jsonObject.has("temperature")) {
                temperature = EnumTemperature.byId(jsonObject.get("temperature").getAsInt());
            }
            ArrayList<Item> additional_seeds = null;
            Item item = null;
            if (jsonObject.has("seeds")) {
                additional_seeds = new ArrayList<Item>();
                for (Iterator element : jsonObject.get("seeds").getAsJsonArray()) {
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString()));
                    if (item != null) {
                        additional_seeds.add(item);
                    }
                    item = null;
                }
            }
            ArrayList<Triple<Item, Integer, Integer>> additional_drops = null;
            if (jsonObject.has("drops")) {
                additional_drops = new ArrayList<Triple<Item, Integer, Integer>>();
                for (Iterator element : jsonObject.get("drops").getAsJsonArray()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("item")) {
                        item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsJsonObject().get("item").getAsString()));
                    } else if (object.has("block")) {
                        item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsJsonObject().get("block").getAsString()));
                    }
                    if (item != null && object.has("min") && object.has("max")) {
                        additional_drops.add((Triple<Item, Integer, Integer>)new ImmutableTriple((Object)item, (Object)object.get("min").getAsInt(), (Object)object.get("max").getAsInt()));
                    }
                    item = null;
                }
            }
            ArrayList<Parents> parents = null;
            if (jsonObject.has("parents")) {
                parents = new ArrayList<Parents>();
                for (JsonElement element : jsonObject.get("parents").getAsJsonArray()) {
                    JsonObject object = element.getAsJsonObject();
                    if (!object.has("partner_1") || !object.has("partner_2") || !object.has("chance")) continue;
                    parents.add(new Parents(object.get("partner_1").getAsString(), object.get("partner_2").getAsString(), object.get("chance").getAsFloat()));
                }
            }
            Block soil = null;
            if (jsonObject.has("soil")) {
                JsonObject soilobject = jsonObject.get("soil").getAsJsonObject();
                if (soilobject.has("item")) {
                    soil = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(soilobject.get("item").getAsString()));
                } else if (soilobject.has("block")) {
                    soil = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(soilobject.get("block").getAsString()));
                }
            }
            return new CropListEntryConfiguration(croplistentry, enabled, temperature, additional_seeds, additional_drops, parents, soil);
        }

        public static CropListEntryConfiguration read(String name, PacketBuffer buf) {
            boolean enabled = buf.readBoolean();
            EnumTemperature temp = EnumTemperature.byId(buf.readByte());
            ArrayList<Item> seeds = null;
            int sizeSeeds = buf.func_150792_a();
            if (sizeSeeds > 0) {
                seeds = new ArrayList<Item>();
                for (int i = 0; i < sizeSeeds; ++i) {
                    seeds.add(Item.func_150899_d((int)buf.func_150792_a()));
                }
            }
            ArrayList<Triple<Item, Integer, Integer>> drops = null;
            int sizeDrops = buf.func_150792_a();
            if (sizeDrops > 0) {
                drops = new ArrayList<Triple<Item, Integer, Integer>>();
                for (int i = 0; i < sizeDrops; ++i) {
                    drops.add((Triple<Item, Integer, Integer>)new ImmutableTriple((Object)Item.func_150899_d((int)buf.func_150792_a()), (Object)buf.func_150792_a(), (Object)buf.func_150792_a()));
                }
            }
            ArrayList<Parents> parents = null;
            int sizeParents = buf.func_150792_a();
            if (sizeParents > 0) {
                parents = new ArrayList<Parents>();
                for (int i = 0; i < sizeParents; ++i) {
                    parents.add(new Parents(buf.func_150789_c(1024), buf.func_150789_c(1024), buf.readFloat()));
                }
            }
            String soilString = buf.func_150789_c(1024);
            Block soil = null;
            if (soilString != "null") {
                soil = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(soilString));
            }
            return new CropListEntryConfiguration(name, enabled, temp, seeds, drops, parents, soil);
        }

        public static void write(PacketBuffer buf, CropListEntryConfiguration cfg) {
            buf.writeBoolean(cfg.enabled);
            buf.writeByte(cfg.temperature.getId());
            if (cfg.seeds != null) {
                buf.func_150787_b(cfg.seeds.size());
                for (Item seed : cfg.seeds) {
                    buf.func_150787_b(Item.func_150891_b((Item)seed));
                }
            } else {
                buf.func_150787_b(0);
            }
            if (cfg.drops != null) {
                buf.func_150787_b(cfg.drops.size());
                for (Triple drop : cfg.drops) {
                    buf.func_150787_b(Item.func_150891_b((Item)((Item)drop.getLeft())));
                    buf.func_150787_b(((Integer)drop.getMiddle()).intValue());
                    buf.func_150787_b(((Integer)drop.getRight()).intValue());
                }
            } else {
                buf.func_150787_b(0);
            }
            if (cfg.parents != null) {
                buf.func_150787_b(cfg.parents.size());
                for (Parents parent_pair : cfg.parents) {
                    buf.func_180714_a(parent_pair.getParent(0));
                    buf.func_180714_a(parent_pair.getParent(1));
                    buf.writeFloat(parent_pair.getMutateChance());
                }
            } else {
                buf.func_150787_b(0);
            }
            if (cfg.soil != null) {
                buf.func_180714_a(cfg.soil.getRegistryName().toString());
            } else {
                buf.func_180714_a("null");
            }
        }
    }
}

