/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityGrave
extends TileEntityWritableGrave {
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    protected final Set<UUID> plunderers = new HashSet<UUID>();
    @Nullable
    private UUID ownerId = null;
    private boolean needAccess = false;

    public TileEntityGrave() {
        super(ModBlocks.tile_grave);
    }

    @Override
    public boolean canShowFog() {
        return true;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public boolean hasEmptyInventory() {
        return IntStream.range(0, this.inventory.getSlots()).allMatch(i -> this.inventory.getStackInSlot(i).func_190926_b());
    }

    public boolean hasEmptySlots(int count) {
        int found = 0;
        for (int i = 0; i < this.inventory.getSlots() && count > found; ++i) {
            if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++found;
        }
        return count <= found;
    }

    public void giveInventory(@Nullable PlayerEntity player) {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.field_72995_K || player == null || player instanceof FakePlayer) {
            return;
        }
        EventFactory.onRestoreInventory(player, this);
        for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
            if (!ovh.corail.tombstone.helper.InventoryHelper.autoequip(this.inventory.getStackInSlot(i), player)) continue;
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        NonNullList swapItems = NonNullList.func_191196_a();
        if (DeathHandler.INSTANCE.getOptionPriorizeToolOnHotbar(player.func_110124_au())) {
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(cap -> {
                int playerSlotId = -1;
                for (int graveSlotId = 0; graveSlotId < this.inventory.getSlots() && playerSlotId < 9; ++graveSlotId) {
                    ItemStack playerStack;
                    if (!ovh.corail.tombstone.helper.InventoryHelper.isTool(this.inventory.getStackInSlot(graveSlotId))) continue;
                    do {
                        playerStack = cap.getStackInSlot(++playerSlotId);
                    } while (playerSlotId < 9 && ovh.corail.tombstone.helper.InventoryHelper.isTool(playerStack));
                    if (playerStack.func_190926_b()) {
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                    } else {
                        swapItems.add((Object)cap.extractItem(playerSlotId, 1, false));
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                    }
                    this.inventory.setStackInSlot(graveSlotId, ItemStack.field_190927_a);
                }
            });
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack2 = this.inventory.getStackInSlot(i);
            if (stack2.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack2.func_77946_l());
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (!swapItems.isEmpty()) {
            swapItems.forEach(stack -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack));
            swapItems.clear();
        }
        this.removeGraveBy(player);
        EntityHelper.capPotionDuration((LivingEntity)player, ModEffects.ghostly_shape, 100);
        player.field_71069_bz.func_75142_b();
        player.func_145747_a(LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.getTranslation());
    }

    public void dropOnGroundAndRemove() {
        if (this.field_145850_b == null) {
            return;
        }
        IntStream.range(0, this.inventory.getSlots()).forEach(i -> {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack.func_77946_l());
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        });
        this.removeGraveBy(null);
    }

    public boolean canPlunder(ServerPlayerEntity player) {
        return EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.tomb_raider) > 0;
    }

    public boolean isAbandoned(ServerPlayerEntity player) {
        int knowledgeLevel = Math.max((Integer)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(ITBCapability::getTotalPerkPoints).orElse((Object)0), 10);
        return TimeHelper.isSystemTimeElapsed(this.getOwnerDeathTime(), TimeUnit.MINUTES.toMillis((Integer)SharedConfigTombstone.general.decayTime.get() == -1 ? 1440L : (long)((float)((Integer)SharedConfigTombstone.general.decayTime.get()).intValue() * (1.0f - (float)knowledgeLevel * 0.05f))));
    }

    public boolean wasPlunderedBy(ServerPlayerEntity player) {
        return this.plunderers.contains(player.func_110124_au());
    }

    public boolean plunder(ServerPlayerEntity player) {
        int maxId = -1;
        for (int slotId = this.inventory.getSlots() - 1; slotId >= 0; --slotId) {
            if (this.inventory.getStackInSlot(slotId).func_190926_b()) continue;
            maxId = slotId + 1;
            break;
        }
        if (maxId == -1) {
            this.removeGraveBy((PlayerEntity)player);
            return false;
        }
        boolean valid = false;
        int nbTry = 3 + Helper.random.nextInt((Integer)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(ITBCapability::getTotalPerkPoints).orElse((Object)1));
        for (int i = 0; i < nbTry; ++i) {
            int id = Helper.random.nextInt(maxId);
            ItemStack stack = this.inventory.getStackInSlot(id);
            if (stack.func_190926_b()) continue;
            valid = true;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.inventory.extractItem(id, stack.func_190916_E(), false));
        }
        if (valid) {
            this.plunderers.add(player.func_110124_au());
            EntityHelper.addAlignment(player, -2);
            if (this.hasEmptyInventory()) {
                this.removeGraveBy((PlayerEntity)player);
            } else {
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    private void removeGraveBy(@Nullable PlayerEntity player) {
        if (this.field_145850_b == null) {
            return;
        }
        DeathHandler.INSTANCE.removeGrave(new Location(this.field_174879_c, (IWorld)this.field_145850_b));
        Helper.removeNoEvent(this.field_145850_b, this.field_174879_c);
        if (player != null) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void setOwner(Entity owner, long deathDate, boolean needAccess) {
        super.setOwner(owner, deathDate);
        this.ownerId = owner.func_110124_au();
        this.needAccess = needAccess;
    }

    public boolean isOwner(PlayerEntity owner) {
        return this.ownerId == null ? this.hasOwner() && this.ownerName.equals(owner.func_146103_bH().getName()) : this.ownerId.equals(owner.func_110124_au());
    }

    public boolean getNeedAccess() {
        return this.needAccess && ((Integer)SharedConfigTombstone.general.decayTime.get() == -1 || !TimeHelper.isSystemTimeElapsed(this.deathDate, TimeUnit.MINUTES.toMillis(((Integer)SharedConfigTombstone.general.decayTime.get()).intValue())));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        if (!this.plunderers.isEmpty()) {
            ListNBT list = new ListNBT();
            this.plunderers.stream().filter(Objects::nonNull).forEach(uuid -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_186854_a("uuid", uuid);
                list.add((Object)nbt);
            });
            compound.func_218657_a("plunderers", (INBT)list);
        }
        return compound;
    }

    @Override
    protected CompoundNBT writeShared(CompoundNBT compound) {
        super.writeShared(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("owner_id", this.ownerId);
        }
        compound.func_74757_a("need_access", this.needAccess);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("inventory", 10)) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_186855_b("owner_id")) {
            this.ownerId = compound.func_186857_a("owner_id");
        }
        this.needAccess = compound.func_74767_n("need_access");
        if (compound.func_150297_b("plunderers", 9)) {
            this.plunderers.clear();
            ListNBT list = compound.func_150295_c("plunderers", 9);
            IntStream.range(0, list.size()).mapToObj(arg_0 -> ((ListNBT)list).func_150305_b(arg_0)).forEach(nbt -> this.plunderers.add(nbt.func_186857_a("uuid")));
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = this.func_189515_b(new CompoundNBT());
        if (nbt.func_150297_b("inventory", 10)) {
            nbt.func_82580_o("inventory");
        }
        return nbt;
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_203425_a(ModTags.Blocks.player_graves)) {
                return;
            }
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.extractItem(i, stack.func_190916_E(), false));
            }
        }
        super.func_145843_s();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }
}

