/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.net.Proxy;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleShadowStep;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModParticleTypes;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements IProxy {
    private boolean isConfigDirty = false;
    private GraveModel lastGraveModel = null;
    private BlockGraveMarble.MarbleType lastMarbleType = null;
    private boolean lastEquipElytraInPriority;
    private boolean lastDisplayKnowledgeMessage;
    private boolean lastPriorizeToolOnHotbar;

    @Override
    public void preInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWritableGrave.class, new RenderWritableGrave());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void produceGraveSmoke(World world, double x, double y, double z) {
        for (int i = 0; i < ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal(); ++i) {
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ModParticleTypes.GRAVE_SMOKE, x + world.field_73012_v.nextGaussian(), y, z + world.field_73012_v.nextGaussian(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void produceShadowStep(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.equals((Object)entity) && mc.field_71474_y.field_74320_O == 0) {
            return;
        }
        if (!entity.func_184218_aH() && !entity.func_70608_bn()) {
            for (double i = 0.0; i < 1.0; i += 0.15) {
                mc.field_71452_i.func_78873_a((Particle)new ParticleShadowStep(entity, i));
            }
        }
    }

    @Override
    public void produceGraveSoul(World world, BlockPos pos) {
        world.func_195594_a((IParticleData)ModParticleTypes.GRAVE_SOUL, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
    }

    @Override
    public void produceParticleCasting(LivingEntity caster, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.func_71410_x();
        if (caster != null) {
            for (int i = 1; i <= 2; ++i) {
                ParticleCasting particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.0, (double)i * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.5, (double)(i + 1) * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.0, (double)i * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.5, (double)(i + 1) * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 2.0, (double)i * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void produceSmokeColumn(World world, double x, double y, double z) {
        world.func_195594_a((IParticleData)ModParticleTypes.SMOKE_COLUMN, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public Proxy getNetProxy() {
        return Minecraft.func_71410_x().func_110437_J();
    }

    @Override
    public void markConfigDirty() {
        this.isConfigDirty = true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isConfigDirty) {
            this.isConfigDirty = false;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                this.lastGraveModel = (GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get());
                this.lastMarbleType = (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get());
                this.lastEquipElytraInPriority = (Boolean)ConfigTombstone.client.equipElytraInPriority.get();
                this.lastDisplayKnowledgeMessage = (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get();
                this.lastPriorizeToolOnHotbar = (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get();
            } else {
                boolean changed = false;
                if (this.lastGraveModel != ConfigTombstone.client.favoriteGrave.get()) {
                    this.lastGraveModel = (GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get());
                    changed = true;
                }
                if (this.lastMarbleType != ConfigTombstone.client.favoriteGraveMarble.get()) {
                    this.lastMarbleType = (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get());
                    changed = true;
                }
                if (this.lastEquipElytraInPriority != (Boolean)ConfigTombstone.client.equipElytraInPriority.get()) {
                    this.lastEquipElytraInPriority = (Boolean)ConfigTombstone.client.equipElytraInPriority.get();
                    changed = true;
                }
                if (this.lastDisplayKnowledgeMessage != (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get()) {
                    this.lastDisplayKnowledgeMessage = (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get();
                    changed = true;
                }
                if (this.lastPriorizeToolOnHotbar != (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get()) {
                    this.lastPriorizeToolOnHotbar = (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get();
                    changed = true;
                }
                if (changed) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Syncing Preferences on Server"));
                    PacketHandler.sendToServer(new UpdateServerMessage((GraveModel)((Object)ConfigTombstone.client.favoriteGrave.get()), (BlockGraveMarble.MarbleType)((Object)ConfigTombstone.client.favoriteGraveMarble.get()), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), (Boolean)ConfigTombstone.client.priorizeToolOnHotbar.get(), false));
                }
            }
        }
    }
}

