/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import ovh.corail.tombstone.helper.Helper;

public enum SupportStructures {
    VILLAGE("Village", 68),
    DESERT_TEMPLE("Desert_Pyramid", 68),
    IGLOO_TEMPLE("Igloo", 68),
    JUNGLE_TEMPLE("Jungle_Pyramid", 68),
    MANSION("Mansion", 68),
    MONUMENT("Monument", 68),
    STRONGHOLD("Stronghold", 35),
    END_CITY("EndCity", 68),
    MINESHAFT("Mineshaft", 37),
    FORTRESS("Fortress", 35),
    SWAMP_HUT("Swamp_Hut", 68),
    OCEAN_RUIN("Ocean_Ruin", 68),
    BURIED_TREASURE("Buried_Treasure", 68),
    SHIPWRECK("Shipwreck", 68),
    PILLAGER_OUTPOST("Pillager_Outpost", 68);

    private final String structureName;
    private final int y;

    private SupportStructures(String structureName, int y) {
        this.structureName = structureName;
        this.y = y;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    public static SupportStructures getStructure(String name) {
        return Stream.of(SupportStructures.values()).filter(p -> p.getStructureName().equals(name)).findFirst().orElse(null);
    }

    @Nullable
    public static SupportStructures getRandomStructure(Predicate<SupportStructures> predic) {
        List list = Stream.of(SupportStructures.values()).filter(predic).collect(Collectors.toList());
        return !list.isEmpty() ? (SupportStructures)((Object)list.get(Helper.getRandom(0, list.size() - 1))) : null;
    }
}

