/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    public final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    public final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    private final HashMap<UUID, Pair<GraveModel, BlockGraveMarble.MarbleType>> optionFavoriteGrave = new HashMap();
    private final HashMap<UUID, Boolean> optionEquipElytraInPriority = new HashMap();
    private final HashMap<UUID, Boolean> optionKnowledgeMessage = new HashMap();
    private final HashMap<UUID, Boolean> optionPriorizeToolOnHotbar = new HashMap();
    private final HashMap<String, Location> lastGraveList = new HashMap();

    private DeathHandler() {
    }

    public Location getLastGrave(String playerName) {
        return this.lastGraveList.getOrDefault(playerName, Location.ORIGIN);
    }

    public void removeGrave(Location pos) {
        Iterator<Map.Entry<String, Location>> it = this.lastGraveList.entrySet().iterator();
        while (it.hasNext()) {
            Location gravePos = it.next().getValue();
            if (!gravePos.equals(pos)) continue;
            it.remove();
        }
    }

    public void logLastGrave(@Nullable PlayerEntity player, int x, int y, int z, int dim) {
        if (player == null) {
            return;
        }
        this.lastGraveList.put(player.func_146103_bH().getName(), new Location(x, y, z, dim));
        if (((Boolean)ConfigTombstone.general.logPlayerGrave.get()).booleanValue()) {
            ModTombstone.LOGGER.info("A new grave of the player " + player.func_146103_bH().getName() + " was created at position [x:" + x + ", y:" + y + ", z:" + z + ", dim:" + dim + "]");
        }
    }

    public boolean isNoGraveLocation(Location location) {
        for (String s : (List)ConfigTombstone.general.noGraveLocation.get()) {
            String[] res;
            if (s.isEmpty() || !((res = s.split(",")).length == 5 ? new Location(Integer.valueOf(res[0].trim()), Integer.valueOf(res[1].trim()), Integer.valueOf(res[2].trim()), Integer.valueOf(res[3].trim())).isInRangeAndDimension(location, Integer.valueOf(res[4].trim())) : res.length == 1 && location.dim == Integer.valueOf(res[0].trim()))) continue;
            return true;
        }
        return false;
    }

    public void setLastDeathLocation(PlayerEntity player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), "tb_last_death_location", location);
    }

    public Location getLastDeathLocation(PlayerEntity player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), "tb_last_death_location");
    }

    public void addPlayerDead(PlayerEntity player) {
        CompoundNBT persistantTag = EntityHelper.getPersistentTag(player);
        persistantTag.func_74757_a("tb_is_player_dead", true);
        this.setLastDeathLocation(player, new Location((Entity)player));
        if (((Boolean)ConfigTombstone.general.restoreEffectsOnDeath.get()).booleanValue() || EntityHelper.isPotionActive((LivingEntity)player, ModEffects.preservation)) {
            ListNBT effectsList = new ListNBT();
            player.func_70651_bq().stream().filter(Helper::isAllowedEffect).forEach(effect -> {
                CompoundNBT effectData = new CompoundNBT();
                effectData.func_74778_a("id", effect.func_188419_a().getRegistryName().toString());
                effectData.func_74768_a("amplifier", effect.func_76458_c());
                effectData.func_74768_a("duration", effect.func_76459_b());
                effectsList.add((Object)effectData);
            });
            persistantTag.func_218657_a("tb_preserved_effects", (INBT)effectsList);
        }
    }

    public void restorePlayerDead(PlayerEntity player) {
        if (!this.isPlayerDead(player)) {
            return;
        }
        if (!Helper.isDisabledPerk(ModPerks.ghostly_shape, player)) {
            EntityHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get() * 20, EntityHelper.getPerkLevelWithBonus(player, ModPerks.ghostly_shape), new boolean[0]);
        }
        CompoundNBT persistantTag = EntityHelper.getPersistentTag(player);
        persistantTag.func_82580_o("tb_is_player_dead");
        if (persistantTag.func_150297_b("tb_preserved_effects", 9)) {
            ListNBT effectList = persistantTag.func_150295_c("tb_preserved_effects", 10);
            for (int i = 0; i < effectList.size(); ++i) {
                Effect effect;
                CompoundNBT effectData = (CompoundNBT)effectList.get(i);
                String id = effectData.func_74779_i("id");
                if (id.length() <= 0 || !Helper.isAllowedEffect(effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(id)))) continue;
                EntityHelper.addEffect((LivingEntity)player, effect, effectData.func_74762_e("duration"), effectData.func_74762_e("amplifier"), new boolean[0]);
            }
            persistantTag.func_82580_o("tb_preserved_effects");
        }
    }

    public boolean isPlayerDead(PlayerEntity player) {
        return EntityHelper.getPersistentTag(player).func_74767_n("tb_is_player_dead");
    }

    public DeathHandler setFavoriteGrave(UUID id, @Nullable GraveModel graveType, @Nullable BlockGraveMarble.MarbleType marbleType) {
        this.optionFavoriteGrave.put(id, (Pair<GraveModel, BlockGraveMarble.MarbleType>)Pair.of((Object)((Object)(graveType != null ? graveType : GraveModel.getDefault())), (Object)((Object)(marbleType != null ? marbleType : BlockGraveMarble.MarbleType.getDefault()))));
        return this;
    }

    public Pair<GraveModel, BlockGraveMarble.MarbleType> getFavoriteGrave(ServerPlayerEntity player) {
        return this.optionFavoriteGrave.getOrDefault(player.func_110124_au(), (Pair<GraveModel, BlockGraveMarble.MarbleType>)Pair.of((Object)((Object)GraveModel.getDefault()), (Object)((Object)BlockGraveMarble.MarbleType.getDefault())));
    }

    public Block getFavoriteGraveBlock(ServerPlayerEntity player) {
        return ModBlocks.graves.get(this.getFavoriteGrave(player).getLeft());
    }

    public DeathHandler setOptionEquipElytraInPriority(UUID id, boolean value) {
        this.optionEquipElytraInPriority.put(id, value);
        return this;
    }

    public boolean getOptionEquipElytraInPriority(UUID id) {
        return this.optionEquipElytraInPriority.getOrDefault(id, false);
    }

    public DeathHandler setOptionKnowledgeMessage(UUID id, boolean value) {
        this.optionKnowledgeMessage.put(id, value);
        return this;
    }

    public boolean getOptionKnowledgeMessage(UUID id) {
        return this.optionKnowledgeMessage.getOrDefault(id, true);
    }

    public DeathHandler setOptionPriorizeToolOnHotbar(UUID id, boolean value) {
        this.optionPriorizeToolOnHotbar.put(id, value);
        return this;
    }

    public boolean getOptionPriorizeToolOnHotbar(UUID id) {
        return this.optionPriorizeToolOnHotbar.getOrDefault(id, false);
    }

    public void handleMobDrops(LivingEntity entity, @Nullable DamageSource damageSource, Collection<ItemEntity> drops) {
        ServerPlayerEntity player;
        ServerPlayerEntity serverPlayerEntity = player = damageSource != null && EntityHelper.isValidPlayerMP(damageSource.func_76346_g()) ? (ServerPlayerEntity)damageSource.func_76346_g() : null;
        if (entity.func_70662_br()) {
            int chanceModifier = EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.bone_collector) * 100;
            if (Helper.getRandom(1, 1000 - chanceModifier) <= (Integer)ConfigTombstone.loot.chanceGraveDust.get() + chanceModifier) {
                drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.grave_dust, Helper.getRandom(1, 2))));
            }
            if (((Boolean)ConfigTombstone.loot.undeadCanDropSkull.get()).booleanValue() && (entity instanceof SkeletonEntity || entity instanceof ZombieEntity) && Helper.getRandom(1, 1000 - chanceModifier) <= 5) {
                ItemStack skullStack = new ItemStack((IItemProvider)(entity instanceof SkeletonEntity ? Items.field_196182_dv : Items.field_196186_dz));
                drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, skullStack));
            }
            if (!entity.func_184222_aU()) {
                ItemScrollBuff scroll;
                if ((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get()) {
                    drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.soul_receptacle)));
                }
                if ((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get() && (scroll = ModItems.scroll_buff[ItemScrollBuff.SpellBuff.getRandomBuff().ordinal()]).isEnabled()) {
                    drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, NBTStackHelper.setBoolean(new ItemStack((IItemProvider)scroll), "enchant", true)));
                }
                if (ModItems.voodoo_poppet.isEnabled() && (Integer)ConfigTombstone.loot.chanceRandomPoppetOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceRandomPoppetOnBoss.get()) {
                    drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, NBTStackHelper.setBoolean(ModItems.voodoo_poppet.addProtection(new ItemStack((IItemProvider)ModItems.voodoo_poppet), ItemVoodooPoppet.PoppetProtections.getRandomProtection()), "enchant", true)));
                }
                if (player != null && (Integer)ConfigTombstone.loot.chanceDecorativeGraveOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceDecorativeGraveOnBoss.get()) {
                    drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)this.getFavoriteGraveBlock(player))));
                }
            }
        }
        if (entity instanceof MonsterEntity && player != null && (Helper.isContributor((PlayerEntity)player) || Helper.isDateAroundHalloween()) && Helper.getRandom(1, 1000) <= 100) {
            drops.add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.lollipop[player.field_70170_p.field_73012_v.nextInt(ModItems.lollipop.length)], 1)));
        }
    }

    public void clear() {
        this.optionFavoriteGrave.clear();
        this.optionEquipElytraInPriority.clear();
        this.optionKnowledgeMessage.clear();
        this.lastGraveList.clear();
    }
}

