/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModParticleTypes;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final KeyBinding keybindKnowledge = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "Corail Tombstone");
    private static boolean isGhostlyRender;
    private static boolean hasTrueSight;
    private static boolean isFirstGuiGameOver;
    private static boolean requireRemovalNightVision;
    private static boolean requireRemovalVisibility;
    private static boolean delayedGui;
    private static long nextGhostTime;
    private static final List<Aura> AURAS;
    private static final ResourceLocation[] AURA_TEXTURES;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientChatEvent(ClientChatEvent event) {
        if ("/tbgui".equals(event.getMessage())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderCreatureEvent(RenderLivingEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (hasTrueSight && EntityHelper.isValidPlayer((PlayerEntity)mc.field_71439_g) && event.getEntity().func_98034_c((PlayerEntity)mc.field_71439_g)) {
            event.getEntity().func_82142_c(false);
            requireRemovalVisibility = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderCreatureEvent(RenderLivingEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (requireRemovalVisibility) {
            event.getEntity().func_82142_c(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (EntityHelper.isValidPlayer((PlayerEntity)player)) {
            if (event.phase == TickEvent.Phase.START) {
                boolean bl = hasTrueSight = EntityHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape, 4) || EntityHelper.isPotionActive((LivingEntity)player, ModEffects.true_sight);
                if (hasTrueSight && !EntityHelper.isPotionActive((LivingEntity)player, Effects.field_76439_r)) {
                    player.func_195064_c(new EffectInstance(Effects.field_76439_r, 1200, 0, true, false));
                    requireRemovalNightVision = true;
                }
            } else if (requireRemovalNightVision) {
                player.func_184596_c(Effects.field_76439_r);
                requireRemovalNightVision = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerTickEvent(TickEvent.ClientTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && EntityHelper.isValidPlayer((PlayerEntity)mc.field_71439_g)) {
            if ((keybindKnowledge.func_151468_f() || delayedGui) && (mc.field_71462_r == null || mc.field_71462_r instanceof ChatScreen)) {
                mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    delayedGui = false;
                    mc.func_147108_a((Screen)new GuiKnowledge((ITBCapability)cap));
                });
            }
            if (((Boolean)ConfigTombstone.client.enableHalloweenEffect.get()).booleanValue() && Helper.isDateAroundHalloween()) {
                if (Helper.isNight((World)mc.field_71441_e)) {
                    long time = mc.field_71441_e.func_82737_E();
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && EntityHelper.canPray((PlayerEntity)mc.field_71439_g)) {
                            Vec3d ghostVec = mc.field_71439_g.func_213303_ch().func_72441_c(Helper.getRandom(-9.0, 9.0), 0.0, Helper.getRandom(-9.0, 9.0));
                            mc.field_71452_i.func_199280_a((IParticleData)ModParticleTypes.GHOST, ghostVec.field_72450_a, ghostVec.field_72448_b, ghostVec.field_72449_c, 0.0, 0.0, 0.0);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        ClientPlayerEntity player;
        if (event.getGui() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (hasTrueSight && event.getInfo().getBlockAtCamera().func_185904_a() == Material.field_151586_h) {
            event.setCanceled(true);
            event.setDensity(event.getDensity() / 4.0f);
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight && event.getInfo().getBlockAtCamera().func_185904_a() == Material.field_151586_h) {
            event.setRed(0.09019608f);
            event.setGreen(0.41568628f);
            event.setBlue(0.9254902f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (hasTrueSight && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(Effects.field_76439_r);
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (SupportMods.canDisplayTooltipOnEnchant() && event.getEntityPlayer() != null && event.getEntityPlayer().field_70170_p != null && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().func_77973_b() == Items.field_151134_bR && event.getItemStack().func_77942_o()) {
            Helper.getTombstoneEnchantments(event.getItemStack()).forEach(enchant -> IntStream.range(0, event.getToolTip().size()).filter(line -> {
                ITextComponent currentTooltip = (ITextComponent)event.getToolTip().get(line);
                return currentTooltip instanceof TranslationTextComponent && enchant.func_77320_a().equals(((TranslationTextComponent)currentTooltip).func_150268_i());
            }).findFirst().ifPresent(line -> {
                List<String> infos = ((TombstoneEnchantment)((Object)enchant)).getTooltipInfos(event.getItemStack());
                for (String info : infos) {
                    event.getToolTip().add(++line, new StringTextComponent(info));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        boolean bl = isGhostlyRender = EntityHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape) || EntityHelper.getPotionDuration((LivingEntity)player, ModEffects.unstable_intangibleness) % 100 > 79;
        if (isGhostlyRender) {
            GlStateManager.Profile.TRANSPARENT_MODEL.func_187373_a();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (isGhostlyRender) {
            GlStateManager.Profile.TRANSPARENT_MODEL.func_187374_b();
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Location location;
        if (!((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.grave_key) {
            location = ModItems.grave_key.getTombPos(stack);
        } else if (stack.func_77973_b() == ModItems.tablet_of_recall) {
            location = ModItems.tablet_of_recall.getTombPos(stack);
        } else if (ModItems.lost_tablet.isWakeUp(stack)) {
            location = ModItems.lost_tablet.getStructurePos(stack);
        } else {
            return;
        }
        if (location.isOrigin() || location.dim != player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() || !World.func_175701_a((BlockPos)location.getPos())) {
            return;
        }
        ClientEventHandler.createBox(location.x, location.y, location.z, 1.0);
    }

    private static void createBox(double x, double y, double z, double offset) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.disableTexture();
        GlStateManager.disableBlend();
        GlStateManager.disableDepthTest();
        Vec3d location = new Vec3d(x, y, z).func_178788_d(mc.field_71460_t.func_215316_n().func_216785_c());
        if (location.func_72438_d(Vec3d.field_186680_a) > 200.0) {
            location = location.func_72432_b().func_186678_a(200.0);
        }
        x = location.field_72450_a;
        y = location.field_72448_b;
        z = location.field_72449_c;
        long c = TimeHelper.systemTime() / 15L % 360L;
        float[] color = Helper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        WorldRenderer.func_189694_a((double)x, (double)y, (double)z, (double)(x + offset), (double)(y + offset), (double)(z + offset), (float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        GlStateManager.enableDepthTest();
        GlStateManager.enableBlend();
        GlStateManager.enableTexture();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void setAuraToRender(RenderLivingEvent.Pre event) {
        AuraType auraType;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && ((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue() && !event.getEntity().func_98034_c((PlayerEntity)mc.field_71439_g) && (auraType = AuraType.getAuraType(event.getEntity())) != null) {
            Aura aura = new Aura(event.getEntity(), auraType);
            double opaque = 1.0;
            double distanceToCamera = mc.func_175598_ae().func_78714_a(((Aura)aura).position.field_72450_a, ((Aura)aura).position.field_72448_b, ((Aura)aura).position.field_72449_c);
            double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
            if (f > 0.0) {
                AURAS.add(aura);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderAuras(RenderWorldLastEvent event) {
        AuraType auraType;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O == 0 && mc.field_71439_g != null && ((Boolean)ConfigTombstone.client.showMagicCircle.get()).booleanValue() && (auraType = AuraType.getAuraType((LivingEntity)mc.field_71439_g)) != null) {
            Aura aura2 = new Aura((LivingEntity)mc.field_71439_g, auraType);
            double opaque = 1.0;
            double distanceToCamera = mc.func_175598_ae().func_78714_a(((Aura)aura2).position.field_72450_a, ((Aura)aura2).position.field_72448_b, ((Aura)aura2).position.field_72449_c);
            double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
            if (f > 0.0) {
                AURAS.add(aura2);
            }
        }
        if (!AURAS.isEmpty()) {
            double ratio = (double)System.currentTimeMillis() * 0.03 % 360.0;
            AURAS.forEach(aura -> ClientEventHandler.renderAura(mc, aura, ratio));
            AURAS.clear();
        }
    }

    private static void renderAura(Minecraft mc, Aura aura, double ratio) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.Profile.PLAYER_SKIN.func_187373_a();
        GlStateManager.disableCull();
        mc.func_175598_ae().field_78724_e.func_110577_a(AURA_TEXTURES[0]);
        Vec3d vec3 = aura.position.func_178788_d(mc.field_71460_t.func_215316_n().func_216785_c());
        GlStateManager.translated((double)vec3.field_72450_a, (double)vec3.field_72448_b, (double)vec3.field_72449_c);
        GlStateManager.rotated((double)ratio, (double)0.0, (double)-1.0, (double)0.0);
        GlStateManager.translated((double)(-vec3.field_72450_a), (double)(-vec3.field_72448_b), (double)(-vec3.field_72449_c));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Vec3d vec1 = new Vec3d(vec3.field_72450_a - aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c - aura.auraType.radius);
        Vec3d vec2 = new Vec3d(vec3.field_72450_a + aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c + aura.auraType.radius);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        bufferbuilder.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableCull();
        GlStateManager.Profile.PLAYER_SKIN.func_187374_b();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)keybindKnowledge);
        isGhostlyRender = false;
        hasTrueSight = false;
        isFirstGuiGameOver = false;
        requireRemovalNightVision = false;
        requireRemovalVisibility = false;
        delayedGui = false;
        nextGhostTime = -1L;
        AURAS = new ArrayList<Aura>();
        AURA_TEXTURES = new ResourceLocation[]{new ResourceLocation("tombstone", "textures/aura/aura1.png")};
    }

    private static class Aura {
        private final Vec3d position;
        private final AuraType auraType;

        private Aura(LivingEntity entity, AuraType auraType) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            this.position = new Vec3d(MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.field_70165_t), MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.field_70163_u), MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.field_70161_v));
            this.auraType = auraType;
        }

        private Aura(double x, double y, double z) {
            this.position = new Vec3d(x, y, z);
            this.auraType = AuraType.MARKER;
        }
    }

    static enum AuraType {
        PRAY(3.5, 0.88f, 0.78f, 0.48f, 1.0f),
        SCROLL(0.8, 0.38f, 0.28f, 0.88f, 1.0f),
        SIMPLE_TELEPORT(0.8, 0.23f, 0.78f, 0.86f, 1.0f),
        AREA_TELEPORT(5.0, 0.23f, 0.78f, 0.86f, 1.0f),
        MARKER(1.0, 0.38f, 0.48f, 0.18f, 1.0f);

        private final double radius;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        private AuraType(double radius, float r, float g, float b, float a) {
            this.radius = radius;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        private static AuraType getAuraType(LivingEntity entity) {
            if (!entity.func_184587_cr()) {
                return null;
            }
            ItemStack heldStack = entity.func_184614_ca();
            Item heldItem = heldStack.func_77973_b();
            if (heldItem == ModItems.ankh_of_pray) {
                return PRAY;
            }
            if (heldItem == ModItems.grave_key || heldItem == ModItems.lost_tablet || heldItem == ModItems.tablet_of_assistance) {
                return SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.tablet_of_recall || heldItem == ModItems.tablet_of_home) {
                return ((ItemGraveMagic)heldStack.func_77973_b()).isAncient(heldStack) ? AREA_TELEPORT : SIMPLE_TELEPORT;
            }
            if (Arrays.stream(ModItems.scroll_buff).anyMatch(item -> item == heldItem) || heldItem == ModItems.scroll_of_knowledge) {
                return SCROLL;
            }
            return null;
        }
    }
}

