/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;

public class EnchantmentMagicSiphon
extends WeaponEnchantment {
    public EnchantmentMagicSiphon() {
        super("magic_siphon", Enchantment.Rarity.RARE, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    @Override
    protected boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentMagicSiphon.get();
    }

    @Override
    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantments.plague_bringer;
    }

    @Override
    public int func_77325_b() {
        return 5;
    }

    @Override
    public void onEntityDamaged(LivingEntity attacker, LivingEntity target, EquipmentSlotType slot, int level) {
        List effects;
        if (slot != EquipmentSlotType.MAINHAND) {
            return;
        }
        boolean canAffectTarget = target.func_70089_S();
        if (canAffectTarget && Helper.random.nextFloat() < (float)level * 0.1f && !(effects = target.func_70651_bq().stream().filter(Helper::isAllowedEffect).collect(Collectors.toList())).isEmpty()) {
            EffectInstance effectInstance = (EffectInstance)effects.get(Helper.random.nextInt(effects.size()));
            Effect effect = effectInstance.func_188419_a();
            int amplifier = effectInstance.func_76458_c();
            int duration = effectInstance.field_76460_b;
            int maxDuration = TimeHelper.tickFromMinute((Integer)ConfigTombstone.enchantments.maxDurationMagicSiphon.get());
            EntityHelper.clearEffect(target, effect);
            boolean canAbsorbAll = duration <= maxDuration;
            EntityHelper.addEffect(attacker, effect, canAbsorbAll ? duration : maxDuration, amplifier, new boolean[0]);
            if (!canAbsorbAll) {
                EntityHelper.addEffect(target, effect, maxDuration - duration, amplifier, new boolean[0]);
            }
            if (target.func_110143_aJ() > target.func_110138_aP()) {
                target.func_70606_j(target.func_110138_aP());
            }
        }
    }
}

