/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.config;

import java.util.BitSet;
import net.minecraftforge.common.ForgeConfigSpec;
import ovh.corail.tombstone.network.UpdateConfigMessage;

public class SharedConfigTombstone {
    public static final General general;
    public static final Enchantments enchantments;
    public static final DecorativeGrave decorative_grave;
    public static final AllowedMagicItems allowed_magic_items;
    public static final Loot loot;
    public static final ForgeConfigSpec CONFIG_SPEC;

    private static String getTranslation(String name) {
        return "tombstone.config." + name;
    }

    private static String getItemTranslation(String name) {
        return "tombstone.item." + name;
    }

    public static UpdateConfigMessage getUpdatePacket() {
        BitSet boolConfigs = new BitSet(BoolConfigs.values().length);
        for (BoolConfigs config : BoolConfigs.values()) {
            boolConfigs.set(config.ordinal(), config.get());
        }
        int[] intConfigs = new int[IntConfigs.values().length];
        for (IntConfigs config : IntConfigs.values()) {
            intConfigs[config.ordinal()] = config.get();
        }
        return new UpdateConfigMessage(boolConfigs, intConfigs);
    }

    public static void updateConfig(BitSet boolConfigs, int[] intConfigs) {
        for (BoolConfigs boolConfigs2 : BoolConfigs.values()) {
            boolConfigs2.set(boolConfigs.get(boolConfigs2.ordinal()));
        }
        for (Enum enum_ : IntConfigs.values()) {
            ((IntConfigs)enum_).set(intConfigs[enum_.ordinal()]);
        }
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        general = new General(BUILDER);
        enchantments = new Enchantments(BUILDER);
        decorative_grave = new DecorativeGrave(BUILDER);
        allowed_magic_items = new AllowedMagicItems(BUILDER);
        loot = new Loot(BUILDER);
        CONFIG_SPEC = BUILDER.build();
    }

    static enum IntConfigs {
        ghostlyShapeDuration(SharedConfigTombstone.general.ghostlyShapeDuration),
        xpLoss(SharedConfigTombstone.general.xpLoss),
        chanceEnchantedGraveKey(SharedConfigTombstone.general.chanceEnchantedGraveKey),
        decayTime(SharedConfigTombstone.general.decayTime),
        familiarReceptacleRequiredLevel(SharedConfigTombstone.general.familiarReceptacleRequiredLevel),
        scrollDuration(SharedConfigTombstone.general.scrollDuration),
        tabletMaxUse(SharedConfigTombstone.decorative_grave.tabletMaxUse),
        cooldownToPray(SharedConfigTombstone.decorative_grave.cooldownToPray),
        chanceLootLostTablet(SharedConfigTombstone.loot.chanceLootLostTablet);

        private ForgeConfigSpec.ConfigValue<Integer> supplier;

        private IntConfigs(ForgeConfigSpec.ConfigValue<Integer> supplier) {
            this.supplier = supplier;
        }

        public int get() {
            return (Integer)this.supplier.get();
        }

        public void set(int value) {
            this.supplier.set((Object)value);
        }
    }

    static enum BoolConfigs {
        handlePlayerXp(SharedConfigTombstone.general.handlePlayerXp),
        allowTombRaiding(SharedConfigTombstone.general.allowTombRaiding),
        nerfShadowStep(SharedConfigTombstone.enchantments.nerfShadowStep),
        enableEnchantmentShadowStep(SharedConfigTombstone.enchantments.enableEnchantmentShadowStep),
        enableEnchantmentSoulbound(SharedConfigTombstone.enchantments.enableEnchantmentSoulbound),
        enableEnchantmentMagicSiphon(SharedConfigTombstone.enchantments.enableEnchantmentMagicSiphon),
        enableEnchantmentPlagueBringer(SharedConfigTombstone.enchantments.enableEnchantmentPlagueBringer),
        unbreakableDecorativeGrave(SharedConfigTombstone.decorative_grave.unbreakableDecorativeGrave),
        allowVoodooPoppet(SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet),
        allowBookOfDisenchantment(SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment),
        allowScrollOfPreservation(SharedConfigTombstone.allowed_magic_items.allowScrollOfPreservation),
        allowGraveKey(SharedConfigTombstone.allowed_magic_items.allowGraveKey),
        allowScrollOfKnowledge(SharedConfigTombstone.allowed_magic_items.allowScrollOfKnowledge),
        allowTabletOfRecall(SharedConfigTombstone.allowed_magic_items.allowTabletOfRecall),
        allowTabletOfHome(SharedConfigTombstone.allowed_magic_items.allowTabletOfHome),
        allowTabletOfAssistance(SharedConfigTombstone.allowed_magic_items.allowTabletOfAssistance),
        allowTabletOfCupidity(SharedConfigTombstone.allowed_magic_items.allowTabletOfCupidity),
        allowScrollOfUnstableIntangibleness(SharedConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibleness),
        allowScrollOfFeatherFall(SharedConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall),
        allowScrollOfPurification(SharedConfigTombstone.allowed_magic_items.allowScrollOfPurification),
        allowScrollOfTrueSight(SharedConfigTombstone.allowed_magic_items.allowScrollOfTrueSight),
        allowLostTablet(SharedConfigTombstone.allowed_magic_items.allowLostTablet),
        allowScrollOfReach(SharedConfigTombstone.allowed_magic_items.allowScrollOfReach),
        allowDustOfVanishing(SharedConfigTombstone.allowed_magic_items.allowDustOfVanishing);

        private ForgeConfigSpec.ConfigValue<Boolean> supplier;

        private BoolConfigs(ForgeConfigSpec.ConfigValue<Boolean> supplier) {
            this.supplier = supplier;
        }

        public boolean get() {
            return (Boolean)this.supplier.get();
        }

        public void set(boolean value) {
            this.supplier.set((Object)value);
        }
    }

    public static class Loot {
        public final ForgeConfigSpec.ConfigValue<Integer> chanceLootLostTablet;

        public Loot(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to change the chance to drop some items").push("loot");
            this.chanceLootLostTablet = builder.comment("Chance to loot a Lost Tablet by fishing [0..1000|default:100]").translation(SharedConfigTombstone.getTranslation("chance_loot_lost_tablet")).defineInRange("chance_loot_lost_tablet", 100, 0, 1000);
            builder.pop();
        }
    }

    public static class AllowedMagicItems {
        public final ForgeConfigSpec.ConfigValue<Boolean> allowVoodooPoppet;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowBookOfDisenchantment;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveKey;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfKnowledge;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfRecall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfHome;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfAssistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTabletOfCupidity;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfPreservation;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfUnstableIntangibleness;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfFeatherFall;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfPurification;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfTrueSight;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowLostTablet;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowScrollOfReach;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowDustOfVanishing;

        public AllowedMagicItems(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to disable some magic items").push("allowedMagicItems");
            this.allowVoodooPoppet = builder.comment("Voodoo Poppet [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("voodoo_poppet")).define("allow_voodoo_poppet", true);
            this.allowBookOfDisenchantment = builder.comment("Book of Disenchantment [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("book_of_disenchantment")).define("allow_book_of_disenchantment", true);
            this.allowGraveKey = builder.comment("Grave's Key [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("grave_key")).define("allow_grave_key", true);
            this.allowScrollOfKnowledge = builder.comment("Scroll of Knowledge [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_knowledge")).define("allow_scroll_of_knowledge", true);
            this.allowTabletOfRecall = builder.comment("Tablet of Recall [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("tablet_of_recall")).define("allow_tablet_of_recall", true);
            this.allowTabletOfHome = builder.comment("Tablet of Home [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("tablet_of_home")).define("allow_tablet_of_home", true);
            this.allowTabletOfAssistance = builder.comment("Tablet of Assistance [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("tablet_of_assistance")).define("allow_tablet_of_assistance", true);
            this.allowTabletOfCupidity = builder.comment("Tablet of Cupidity [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("tablet_of_cupidity")).define("allow_tablet_of_cupidity", true);
            this.allowScrollOfPreservation = builder.comment("Scroll of Preservation [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_preservation")).define("allow_scroll_of_preservation", true);
            this.allowScrollOfUnstableIntangibleness = builder.comment("Scroll of Unstable Intangibleness [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_unstable_intangibleness")).define("allow_scroll_of_unstable_intangibleness", true);
            this.allowScrollOfFeatherFall = builder.comment("Scroll of Feather Fall [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_feather_fall")).define("allow_scroll_of_feather_fall", true);
            this.allowScrollOfPurification = builder.comment("Scroll of Purification [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_purification")).define("allow_scroll_of_purification", true);
            this.allowScrollOfTrueSight = builder.comment("Scroll of True Sight [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_true_sight")).define("allow_scroll_of_true_sight", true);
            this.allowLostTablet = builder.comment("Lost Tablet [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("lost_tablet")).define("allow_lost_tablet", true);
            this.allowScrollOfReach = builder.comment("Scroll of Reach [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("scroll_of_reach")).define("allow_scroll_of_reach", true);
            this.allowDustOfVanishing = builder.comment("Dust of Vanishing [false/true|default:true]").translation(SharedConfigTombstone.getItemTranslation("dust_of_vanishing")).define("allow_dust_of_vanishing", true);
            builder.pop();
        }
    }

    public static class DecorativeGrave {
        public final ForgeConfigSpec.ConfigValue<Integer> tabletMaxUse;
        public final ForgeConfigSpec.ConfigValue<Boolean> unbreakableDecorativeGrave;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownToPray;

        public DecorativeGrave(ForgeConfigSpec.Builder builder) {
            builder.comment("For settings related to decorative tombs and magic items").push("decorative_grave");
            this.tabletMaxUse = builder.comment("Maximum uses of a tablet [1..20|default:10]").translation(SharedConfigTombstone.getTranslation("tablet_max_use")).defineInRange("tablet_max_use", 10, 1, 20);
            this.unbreakableDecorativeGrave = builder.comment("Sets the decorative graves unbreakable [false/true|default:false]").translation(SharedConfigTombstone.getTranslation("unbreakable_decorative_grave")).define("unbreakable_decorative_grave", false);
            this.cooldownToPray = builder.comment("The cooldown in hours to pray with the \u00c3\u201ankh [1..10|default:3]").translation(SharedConfigTombstone.getTranslation("cooldown_to_pray")).defineInRange("cooldown_to_pray", 3, 1, 10);
            builder.pop();
        }
    }

    public static class Enchantments {
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfShadowStep;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentShadowStep;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentSoulbound;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentMagicSiphon;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantmentPlagueBringer;

        public Enchantments(ForgeConfigSpec.Builder builder) {
            builder.comment("Allows to customize or disable the enchantments").push("enchantments");
            this.nerfShadowStep = builder.comment("Shadow Step is only active while sneaking [false/true|default:false]").translation(SharedConfigTombstone.getTranslation("nerf_shadow_step")).define("nerf_shadow_step", false);
            this.enableEnchantmentShadowStep = builder.comment("Enables the enchantment Shadow Step [false/true|default:true]").translation(SharedConfigTombstone.getTranslation("enable_enchantment_shadow_step")).define("enable_enchantment_shadow_step", true);
            this.enableEnchantmentSoulbound = builder.comment("Enables the enchantment Soulbound [false/true|default:true]").translation(SharedConfigTombstone.getTranslation("enable_enchantment_soulbound")).define("enable_enchantment_soulbound", true);
            this.enableEnchantmentMagicSiphon = builder.comment("Enables the enchantment Magic Siphon [false/true|default:true]").translation(SharedConfigTombstone.getTranslation("enable_enchantment_magic_siphon")).define("enable_enchantment_magic_siphon", true);
            this.enableEnchantmentPlagueBringer = builder.comment("Enables the enchantment Plague Bringer [false/true|default:true]").translation(SharedConfigTombstone.getTranslation("enable_enchantment_plague_bringer")).define("enable_enchantment_plague_bringer", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> handlePlayerXp;
        public final ForgeConfigSpec.ConfigValue<Integer> ghostlyShapeDuration;
        public final ForgeConfigSpec.ConfigValue<Integer> xpLoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceEnchantedGraveKey;
        public final ForgeConfigSpec.ConfigValue<Integer> decayTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTombRaiding;
        public final ForgeConfigSpec.ConfigValue<Integer> familiarReceptacleRequiredLevel;
        public final ForgeConfigSpec.ConfigValue<Integer> scrollDuration;

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Miscellaneous options").push("general");
            this.handlePlayerXp = builder.comment("Whether to handle player experience [false/true|default:true]").translation(SharedConfigTombstone.getTranslation("handle_player_xp")).define("handle_player_xp", true);
            this.ghostlyShapeDuration = builder.comment("The duration of the Ghostly Shape effect in seconds [0..MAX|default:120]").translation(SharedConfigTombstone.getTranslation("ghostly_shape_duration")).defineInRange("ghostly_shape_duration", 120, 0, Integer.MAX_VALUE);
            this.xpLoss = builder.comment("Experience loss on death (%) [0..100|default:0]").translation(SharedConfigTombstone.getTranslation("xp_loss")).defineInRange("xp_loss", 0, 0, 100);
            this.chanceEnchantedGraveKey = builder.comment("The chance that a player receives an already enchanted Grave's Key on death [-1..100|default:0|disabled:-1]").translation(SharedConfigTombstone.getTranslation("chance_enchanted_graveKey")).defineInRange("chance_enchanted_graveKey", 0, -1, 100);
            this.decayTime = builder.comment("The time in minutes before a Grave's Key isn't required to open a grave (-1 = disabled) [-1..MAX|default:-1]").translation(SharedConfigTombstone.getTranslation("decay_time")).defineInRange("decay_time", -1, -1, Integer.MAX_VALUE);
            this.allowTombRaiding = builder.comment("Allows players with bad alignment and the perk tomb raider to steal items on abandoned graves [false/true|default:false]").translation(SharedConfigTombstone.getTranslation("allow_tomb_raiding")).define("allow_tomb_raiding", false);
            this.familiarReceptacleRequiredLevel = builder.comment("Required level in Knowledge of Death to craft Familiar Receptacle [0..20|default:10]").translation(SharedConfigTombstone.getTranslation("familiar_receptacle_required_level")).defineInRange("familiar_receptacle_required_level", 10, 0, 20);
            this.scrollDuration = builder.comment("Scroll duration [1200..120000|default:12000]").translation(SharedConfigTombstone.getTranslation("scroll_duration")).defineInRange("scroll_duration", 12000, 1200, 120000);
            builder.pop();
        }
    }
}

