/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;

public class CompatibilityDruidCraft {
    public static final CompatibilityDruidCraft instance = new CompatibilityDruidCraft();
    private final Method methodGetOwnerId;
    private final Method methodSetTamedBy;

    private CompatibilityDruidCraft() {
        ModList modList = ModList.get();
        Class<?> classTameableMonsterEntity = modList != null && modList.getModContainerById("druidcraft").isPresent() ? Helper.getClass("com.vulp.druidcraft.entities.TameableMonsterEntity") : null;
        this.methodGetOwnerId = Helper.getMethod(classTameableMonsterEntity, "getOwnerId", new Class[0]);
        this.methodSetTamedBy = Helper.getMethod(classTameableMonsterEntity, "setTamedBy", PlayerEntity.class);
    }

    public boolean isValid() {
        return this.methodGetOwnerId != null && this.methodSetTamedBy != null;
    }

    public boolean isTameable(EntityType<?> type) {
        ResourceLocation typeRL = type.getRegistryName();
        return SupportMods.DRUIDCRAFT.isLoaded() && typeRL != null && typeRL.func_110624_b().equals(SupportMods.DRUIDCRAFT.func_176610_l()) && typeRL.func_110623_a().equals("beetle");
    }

    @Nullable
    public UUID getOwnerId(LivingEntity entity) {
        try {
            return (UUID)this.methodGetOwnerId.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTameBy(LivingEntity entity, PlayerEntity player) {
        try {
            this.methodSetTamedBy.invoke((Object)entity, player);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

