/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

abstract class TombstoneCommand {
    private final CommandDispatcher<CommandSource> commandDispatcher;

    public TombstoneCommand(CommandDispatcher<CommandSource> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    abstract String getName();

    public ITextComponent getUsage() {
        return new TranslationTextComponent("tombstone.command." + this.getName() + ".usage", new Object[0]);
    }

    public int getPermissionLevel() {
        return 2;
    }

    public int showUsage(CommandSource source) {
        source.func_197030_a(this.getUsage(), false);
        return 1;
    }

    abstract LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> var1);

    public void registerCommand() {
        LiteralArgumentBuilder<CommandSource> builder = this.getBuilder((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(p -> p.func_197034_c(this.getPermissionLevel()))));
        this.commandDispatcher.register(builder);
    }

    static void checkAlive(Entity entity) {
        if (!entity.func_70089_S()) {
            throw new CommandException(LangKey.MESSAGE_DEAD_ENTITY.getTranslation());
        }
    }

    static void checkNotSpectator(Entity entity) {
        if (entity instanceof PlayerEntity) {
            TombstoneCommand.checkNotSpectator((PlayerEntity)entity);
        }
    }

    static void checkNotSpectator(PlayerEntity player) {
        if (EntityHelper.isValidPlayer(player) && player.func_175149_v()) {
            throw new CommandException(LangKey.MESSAGE_PLAYER_SPECTATOR.getTranslation());
        }
    }

    static void checkValidPos(World world, BlockPos pos) {
        if (!Helper.isValidPos(world, pos)) {
            throw new CommandException(LangKey.MESSAGE_INVALID_LOCATION.getTranslation());
        }
    }

    DimensionType getOrThrowDimensionType(int dim) {
        DimensionType dimensionType = DimensionType.func_186069_a((int)dim);
        if (dimensionType == null) {
            throw new CommandException(LangKey.MESSAGE_NO_DIMENSION.getTranslation());
        }
        return dimensionType;
    }

    Biome getOrThrowBiome(CommandContext<CommandSource> context, String name) {
        ResourceLocation rl = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        return (Biome)Registry.field_212624_m.func_218349_b(rl).orElseThrow(() -> new CommandException(LangKey.MESSAGE_INVALID_BIOME.getTranslation()));
    }

    protected void sendMessage(CommandSource source, ITextComponent message, boolean allowLogging) {
        source.func_197030_a(message.func_150255_a(StyleType.TOOLTIP_DESC), allowLogging);
    }
}

