/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.SuggestionProviders;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;

public class CommandTBTeleportDiscovery
extends TombstoneCommand {
    public CommandTBTeleportDiscovery(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleportdiscovery";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        ((LiteralArgumentBuilder)builder.executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target")))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.SUGGESTION_STRUCTURE).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), StringArgumentType.getString((CommandContext)c, (String)"structure")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)IntegerArgumentType.integer()).suggests(SuggestionProviders.SUGGESTION_DIM_IDS).executes(c -> this.teleportDiscovery((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), StringArgumentType.getString((CommandContext)c, (String)"structure"), ((CommandSource)c.getSource()).func_197028_i().func_71218_a(this.getOrThrowDimensionType(IntegerArgumentType.getInteger((CommandContext)c, (String)"dim"))))))));
        return builder;
    }

    private int teleportDiscovery(CommandSource sender, Entity target) {
        return this.teleportDiscovery(sender, target, SupportStructures.VILLAGE.getStructureName());
    }

    private int teleportDiscovery(CommandSource sender, Entity target, String structureString) {
        return this.teleportDiscovery(sender, target, structureString, (ServerWorld)target.field_70170_p);
    }

    private int teleportDiscovery(CommandSource sender, Entity target, String structureString, ServerWorld world) throws CommandException {
        CommandTBTeleportDiscovery.checkAlive(target);
        CommandTBTeleportDiscovery.checkNotSpectator(target);
        SupportStructures struct = SupportStructures.getStructure(structureString);
        if (struct == null) {
            throw new CommandException(LangKey.MESSAGE_INVALID_STRUCTURE.getTranslation());
        }
        Location structureLoc = Helper.findNearestStructure(world, target.func_180425_c(), struct, true);
        if (structureLoc.isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_STRUCTURE.getTranslation());
        }
        Location spawnLoc = new SpawnHelper(world, structureLoc.getPos()).findPlaceInStructure(struct);
        if (spawnLoc.isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_SPAWN.getTranslation());
        }
        CallbackHandler.addCallback(1, () -> {
            Entity newEntity = Helper.teleportEntity(target, spawnLoc);
            if (EntityHelper.isValidPlayer(newEntity)) {
                newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
            }
            this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim), false);
        });
        return 1;
    }
}

