/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBTeleportDeath
extends TombstoneCommand {
    public CommandTBTeleportDeath(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbteleportdeath";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)builder.executes(c -> this.teleportDeath((CommandSource)c.getSource()));
    }

    private int teleportDeath(CommandSource sender) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportDeath.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayerEntity player = sender.func_197035_h();
        CommandTBTeleportDeath.checkAlive((Entity)player);
        CommandTBTeleportDeath.checkNotSpectator((PlayerEntity)player);
        Location lastDeathLocation = DeathHandler.INSTANCE.getLastDeathLocation((PlayerEntity)player);
        if (lastDeathLocation.isOrigin()) {
            throw LangKey.MESSAGE_NO_DEATH_LOCATION.asCommandException(new Object[0]);
        }
        LazyOptional supplierCap = player.getCapability(TBCapabilityProvider.TB_CAPABILITY);
        int cd = (Integer)supplierCap.map(cap -> cap.getCooldownToTeleportDeath(player)).orElse((Object)TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportDeath.get()));
        if (cd > 0) {
            int[] timeArray = TimeHelper.getTimeArray(cd);
            player.func_145747_a(LangKey.MESSAGE_COMMAND_IN_COOLDOWN.getTranslation(timeArray[0], timeArray[1], timeArray[2]));
            return 0;
        }
        DimensionType dimensionType = this.getOrThrowDimensionType(lastDeathLocation.dim);
        ServerWorld world = sender.func_197028_i().func_71218_a(dimensionType);
        Location location = new SpawnHelper(world, lastDeathLocation.getPos()).findSpawnPlace(false);
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        ServerPlayerEntity newEntity = Helper.teleportEntity(player, location);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            supplierCap.ifPresent(cap -> cap.setCooldownToTeleportDeath(TimeHelper.worldTicks(player.field_70170_p) + (long)TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportDeath.get())));
            newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(), location.x, location.y, location.z, location.dim), false);
        return 1;
    }
}

