/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.SuggestionProviders;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBTeleportBiome
extends TombstoneCommand {
    public CommandTBTeleportBiome(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbteleportbiome";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        ((LiteralArgumentBuilder)builder.executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SuggestionProviders.SUGGESTION_BIOME).executes(c -> this.teleportBiome((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), this.getOrThrowBiome((CommandContext<CommandSource>)c, "biome")))).then(Commands.func_197056_a((String)"dim", (ArgumentType)IntegerArgumentType.integer()).suggests(SuggestionProviders.SUGGESTION_DIM_IDS).executes(c -> this.teleportBiome((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), this.getOrThrowBiome((CommandContext<CommandSource>)c, "biome"), ((CommandSource)c.getSource()).func_197028_i().func_71218_a(this.getOrThrowDimensionType(IntegerArgumentType.getInteger((CommandContext)c, (String)"dim"))))))));
        return builder;
    }

    private int teleportBiome(CommandSource sender, Entity target, Biome biome) {
        return this.teleportBiome(sender, target, biome, (ServerWorld)target.field_70170_p);
    }

    private int teleportBiome(CommandSource sender, Entity target, Biome biome, ServerWorld world) throws CommandException {
        CommandTBTeleportBiome.checkAlive(target);
        CommandTBTeleportBiome.checkNotSpectator(target);
        BlockPos startingPos = target.func_180425_c();
        Location biomePos = Location.ORIGIN;
        for (int nbTry = 0; biomePos.isOrigin() && nbTry < 3; ++nbTry) {
            startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177963_a((double)nbTry * Helper.random.nextGaussian() * 5000.0, 0.0, (double)nbTry * Helper.random.nextGaussian() * 5000.0));
            biomePos = this.findNearestBiome(world, startingPos.func_177958_n(), startingPos.func_177956_o(), startingPos.func_177952_p(), 4300, 8, Collections.singletonList(biome), Helper.random, true);
        }
        if (biomePos.isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_BIOME.getTranslation());
        }
        Location spawnLoc = new SpawnHelper(world, biomePos.getPos()).findSpawnPlace(false);
        if (spawnLoc.isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_SPAWN.getTranslation());
        }
        CallbackHandler.addCallback(1, () -> {
            Entity newEntity = Helper.teleportEntity(target, spawnLoc);
            if (EntityHelper.isValidPlayer(newEntity)) {
                newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
            }
            this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim), false);
        });
        return 1;
    }

    private Location findNearestBiome(ServerWorld world, int x, int y, int z, int radius, int radiusStep, List<Biome> biomes, Random random, boolean onionSearch) {
        int radiusMin;
        BiomeProvider biomeProvider = world.func_72863_F().func_201711_g().func_202090_b();
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        int xMin = x >> 2;
        int zMin = z >> 2;
        int radiusMax = radius >> 2;
        Location biomePos = Location.ORIGIN;
        int count = 0;
        for (int actualRadius = radiusMin = onionSearch ? 0 : radiusMax; actualRadius <= radiusMax; actualRadius += radiusStep) {
            for (int biomeStepZ = -actualRadius; biomeStepZ <= actualRadius; biomeStepZ += radiusStep) {
                boolean onEdgeZ = Math.abs(biomeStepZ) == actualRadius;
                for (int biomeStepX = -actualRadius; biomeStepX <= actualRadius; biomeStepX += radiusStep) {
                    int zBiomeChunk;
                    int xBiomeChunk;
                    if (onionSearch) {
                        boolean onEdgeX;
                        boolean bl = onEdgeX = Math.abs(biomeStepX) == actualRadius;
                        if (!onEdgeX && !onEdgeZ) continue;
                    }
                    if (!biomes.contains(biomeProvider.func_222366_b(xBiomeChunk = xMin + biomeStepX, zBiomeChunk = zMin + biomeStepZ))) continue;
                    if (biomePos.isOrigin() || random.nextInt(count + 1) == 0) {
                        biomePos = new Location(xBiomeChunk << 2, y, zBiomeChunk << 2, dimId);
                        if (onionSearch) {
                            return biomePos;
                        }
                    }
                    ++count;
                }
            }
        }
        return biomePos;
    }
}

