/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

public class CommandTBRestoreInventory
extends TombstoneCommand {
    public CommandTBRestoreInventory(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbrestoreinventory";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.restoreInventory((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h()));
        builder.then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.restoreInventory((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"))));
        return builder;
    }

    private int restoreInventory(CommandSource sender, ServerPlayerEntity target) throws CommandException {
        CommandTBRestoreInventory.checkAlive((Entity)target);
        CommandTBRestoreInventory.checkNotSpectator((PlayerEntity)target);
        Location lastGrave = DeathHandler.INSTANCE.getLastGrave(target.func_146103_bH().getName());
        if (lastGrave.isOrigin() && (lastGrave = ModItems.grave_key.getTombPos(ModItems.grave_key.findFirstKeyInInventory((PlayerEntity)target))).isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_GRAVE.getTranslation());
        }
        DimensionType dimensionType = this.getOrThrowDimensionType(lastGrave.dim);
        ServerWorld world = sender.func_197028_i().func_71218_a(dimensionType);
        CommandTBRestoreInventory.checkValidPos((World)world, lastGrave.getPos());
        TileEntity tile = world.func_175625_s(lastGrave.getPos());
        if (tile instanceof TileEntityGrave) {
            ModItems.grave_key.removeKeyForGraveInInventory((PlayerEntity)target, lastGrave);
            ((TileEntityGrave)tile).giveInventory((PlayerEntity)target);
            target.func_145747_a(LangKey.MESSAGE_RECOVER_LOST_ITEMS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
            this.sendMessage(sender, LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.getTranslation(), false);
        }
        return 1;
    }
}

