/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerUtil {
    public static int getItemCount(IItemHandler handler, Predicate<? super ItemStack> predicate) {
        return ItemHandlerUtil.getStackStream(handler).filter(predicate).mapToInt(ItemStack::func_190916_E).sum();
    }

    public static Stream<ItemStack> getStackStream(IItemHandler handler) {
        return IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0));
    }

    public static List<ItemStack> extractItems(IItemHandler handler, Predicate<? super ItemStack> predicate, int extractCount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        AtomicInteger countLeft = new AtomicInteger(extractCount);
        IntStream.range(0, handler.getSlots()).filter(slot -> predicate.test(handler.getStackInSlot(slot))).forEach(slot -> {
            int count = countLeft.get();
            if (count > 0) {
                ItemStack stack = handler.extractItem(slot, count, false);
                countLeft.set(count - stack.func_190916_E());
                list.add(stack);
            }
        });
        return list;
    }

    public static ItemStack getOneItemAndRemove(List<ItemStack> list) {
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = list.get(0);
        ItemStack oneItemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            list.remove(0);
        }
        return oneItemStack;
    }
}

