/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.recipes;

import al132.alchemistry.Alchemistry;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.recipes.ProbabilitySet;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DissolverRecipe {
    public Ingredient input;
    public boolean reversible = false;
    public ProbabilitySet outputs;

    public DissolverRecipe(Builder builder) {
        this(builder.input, builder.outputs);
        this.reversible = builder.reversible;
    }

    public DissolverRecipe(Ingredient input, ProbabilitySet outputs) {
        this.input = input;
        this.outputs = outputs;
    }

    public DissolverRecipe copy() {
        return new DissolverRecipe(this.input, this.outputs);
    }

    @Nullable
    public static DissolverRecipe match(ItemStack input, boolean quantitySensitive) {
        for (DissolverRecipe recipe : ModRecipes.dissolverRecipes) {
            for (ItemStack recipeStack : (ItemStack[])recipe.input.func_193365_a().clone()) {
                if (!ItemStack.func_179545_c((ItemStack)recipeStack, (ItemStack)input)) continue;
                if (quantitySensitive && input.func_190916_E() >= recipeStack.func_190916_E()) {
                    return recipe.copy();
                }
                if (quantitySensitive) continue;
                return recipe.copy();
            }
        }
        return null;
    }

    public static class Builder {
        private Ingredient input;
        private ProbabilitySet outputs;
        private boolean reversible = false;

        public Builder outputs(ProbabilitySet set) {
            this.outputs = set;
            return this;
        }

        public Builder input(ItemStack input) {
            this.input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input});
            return this;
        }

        public Builder input(Item input) {
            this.input = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input});
            return this;
        }

        public Builder setReversible(boolean value) {
            this.reversible = value;
            return this;
        }

        public Builder input(String tagLocation) {
            this.input = Ingredient.func_199805_a((Tag)new ItemTags.Wrapper(new ResourceLocation(tagLocation)));
            return this;
        }

        public Builder input(Ingredient input) {
            this.input = input;
            return this;
        }

        public void build() {
            String outs;
            String ins = this.input == null ? "null" : this.input.toString();
            String string = outs = this.outputs == null ? "null" : this.outputs.toString();
            if (this.input != null && this.outputs != null) {
                ModRecipes.dissolverRecipes.add(new DissolverRecipe(this));
            } else {
                Alchemistry.LOGGER.warn("Invalid dissolver recipe - input[" + ins + "], outputs[" + outs + "]");
            }
        }
    }
}

