/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.compat.jei;

import al132.alchemistry.Alchemistry;
import al132.alchemistry.Ref;
import al132.alchemistry.blocks.atomizer.AtomizerScreen;
import al132.alchemistry.blocks.combiner.CombinerScreen;
import al132.alchemistry.blocks.dissolver.DissolverContainer;
import al132.alchemistry.blocks.dissolver.DissolverScreen;
import al132.alchemistry.blocks.evaporator.EvaporatorScreen;
import al132.alchemistry.blocks.fission.FissionContainer;
import al132.alchemistry.blocks.fission.FissionScreen;
import al132.alchemistry.blocks.liquifier.LiquifierContainer;
import al132.alchemistry.blocks.liquifier.LiquifierScreen;
import al132.alchemistry.compat.jei.CombinerTransferHandler;
import al132.alchemistry.compat.jei.category.AtomizerRecipeCategory;
import al132.alchemistry.compat.jei.category.CombinerRecipeCategory;
import al132.alchemistry.compat.jei.category.DissolverRecipeCategory;
import al132.alchemistry.compat.jei.category.EvaporatorRecipeCategory;
import al132.alchemistry.compat.jei.category.FissionRecipeCategory;
import al132.alchemistry.compat.jei.category.LiquifierRecipeCategory;
import al132.alchemistry.recipes.ModRecipes;
import al132.chemlib.chemistry.ElementRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final String ATOMIZER_CATEGORY = "atomizer_recipe";
    public static final String COMBINER_CATEGORY = "combiner_recipe";
    public static final String DISSOLVER_CATEGORY = "dissolver_recipe";
    public static final String EVAPORATOR_CATEGORY = "evaporator_recipe";
    public static final String FISSION_CATEGORY = "fission_recipe";
    public static final String LIQUIFIER_CATEGORY = "liquifier_recipe";
    public static final ResourceLocation ATOMIZER_RESOURCE = new ResourceLocation(Alchemistry.data.MODID, "atomizer_recipe");
    public static final ResourceLocation COMBINER_RESOURCE = new ResourceLocation(Alchemistry.data.MODID, "combiner_recipe");
    public static final ResourceLocation DISSOLVER_RESOURCE = new ResourceLocation(Alchemistry.data.MODID, "dissolver_recipe");
    public static final ResourceLocation EVAPORATOR_RESOURCE = new ResourceLocation(Alchemistry.data.MODID, "evaporator_recipe");
    public static final ResourceLocation FISSION_RESOURCE = new ResourceLocation(Alchemistry.data.MODID, "fission_recipe");
    public static final ResourceLocation LIQUIFIER_RESOURCE = new ResourceLocation(Alchemistry.data.MODID, "liquifier_recipe");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation(Alchemistry.data.MODID, "alchemistry");
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new AtomizerRecipeCategory(guiHelper), new CombinerRecipeCategory(guiHelper), new DissolverRecipeCategory(guiHelper), new EvaporatorRecipeCategory(guiHelper), new FissionRecipeCategory(guiHelper), new LiquifierRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        ModRecipes.filterEmptyDissolverRecipes();
        reg.addRecipes(ModRecipes.atomizerRecipes, ATOMIZER_RESOURCE);
        reg.addRecipes(ModRecipes.combinerRecipes, COMBINER_RESOURCE);
        reg.addRecipes(ModRecipes.dissolverRecipes, DISSOLVER_RESOURCE);
        reg.addRecipes(ModRecipes.evaporatorRecipes, EVAPORATOR_RESOURCE);
        reg.addRecipes(ModRecipes.fissionRecipes, FISSION_RESOURCE);
        reg.addRecipes(ModRecipes.liquifierRecipes, LIQUIFIER_RESOURCE);
        ElementRegistry.elements.forEach((key, value) -> reg.addIngredientInfo((Object)new ItemStack((IItemProvider)value), VanillaTypes.ITEM, new String[]{"alchemistry.jei.elements.description"}));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration reg) {
        reg.addRecipeTransferHandler((IRecipeTransferHandler)new CombinerTransferHandler(), COMBINER_RESOURCE);
        reg.addRecipeTransferHandler(DissolverContainer.class, DISSOLVER_RESOURCE, 0, 1, 11, 36);
        reg.addRecipeTransferHandler(FissionContainer.class, FISSION_RESOURCE, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(LiquifierContainer.class, LIQUIFIER_RESOURCE, 0, 1, 1, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Ref.atomizer), new ResourceLocation[]{ATOMIZER_RESOURCE});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Ref.combiner), new ResourceLocation[]{COMBINER_RESOURCE});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Ref.dissolver), new ResourceLocation[]{DISSOLVER_RESOURCE});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Ref.evaporator), new ResourceLocation[]{EVAPORATOR_RESOURCE});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Ref.fissionController), new ResourceLocation[]{FISSION_RESOURCE});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Ref.liquifier), new ResourceLocation[]{LIQUIFIER_RESOURCE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(AtomizerScreen.class, 73, 54, 39, 23, new ResourceLocation[]{ATOMIZER_RESOURCE});
        reg.addRecipeClickArea(CombinerScreen.class, 100, 20, 35, 33, new ResourceLocation[]{COMBINER_RESOURCE});
        reg.addRecipeClickArea(DissolverScreen.class, 86, 50, 17, 33, new ResourceLocation[]{DISSOLVER_RESOURCE});
        reg.addRecipeClickArea(EvaporatorScreen.class, 73, 54, 39, 23, new ResourceLocation[]{EVAPORATOR_RESOURCE});
        reg.addRecipeClickArea(FissionScreen.class, 73, 54, 39, 23, new ResourceLocation[]{FISSION_RESOURCE});
        reg.addRecipeClickArea(LiquifierScreen.class, 73, 54, 39, 23, new ResourceLocation[]{LIQUIFIER_RESOURCE});
    }
}

