/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BookRightClickHandler {
    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        BookEntry entry;
        Pair<BookEntry, Integer> hover;
        Book book;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack bookStack = player.func_184614_ca();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && mc.field_71462_r == null && (book = BookRightClickHandler.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null && !(entry = (BookEntry)hover.getLeft()).isLocked()) {
            MainWindow window = event.getWindow();
            int x = window.func_198107_o() / 2 + 3;
            int y = window.func_198087_p() / 2 + 3;
            entry.getIcon().render(x, y);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            mc.func_175599_af().func_180450_b(bookStack, (x + 8) * 2, (y + 8) * 2);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            mc.field_71466_p.func_175063_a(entry.getName(), (float)(x + 18), (float)(y + 3), 0xFFFFFF);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.75f, (float)0.75f, (float)1.0f);
            String s = I18n.func_135052_a((String)("patchouli.gui.lexicon." + (player.func_70093_af() ? "view" : "sneak")), (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(TextFormatting.ITALIC + s, (float)(x + 18) / 0.75f, (float)(y + 14) / 0.75f, 0xBBBBBB);
            GlStateManager.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BookEntry entry;
        Pair<BookEntry, Integer> hover;
        Book book;
        PlayerEntity player = event.getPlayer();
        ItemStack bookStack = player.func_184614_ca();
        if (event.getWorld().field_72995_K && player.func_70093_af() && (book = BookRightClickHandler.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null && !(entry = (BookEntry)hover.getLeft()).isLocked()) {
            GuiBookEntry currEntry;
            int page = (Integer)hover.getRight();
            GuiBook curr = book.contents.getCurrentGui();
            book.contents.currentGui = new GuiBookEntry(book, entry, page);
            player.func_184609_a(Hand.MAIN_HAND);
            if (curr instanceof GuiBookEntry && (currEntry = (GuiBookEntry)curr).getEntry() == entry && currEntry.getPage() == page) {
                return;
            }
            book.contents.guiStack.push(curr);
        }
    }

    private static Book getBookFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!b.getBookItem().func_77969_a(stack)) continue;
            return b;
        }
        return null;
    }

    private static Pair<BookEntry, Integer> getHoveredEntry(Book book) {
        BlockPos pos;
        BlockState state;
        Block block;
        ItemStack picked;
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult res = mc.field_71476_x;
        if (res != null && res instanceof BlockRayTraceResult && !(picked = (block = (state = mc.field_71441_e.func_180495_p(pos = ((BlockRayTraceResult)res).func_216350_a())).func_177230_c()).getPickBlock(state, res, (IBlockReader)mc.field_71441_e, pos, (PlayerEntity)mc.field_71439_g)).func_190926_b()) {
            return book.contents.recipeMappings.get(ItemStackUtil.wrapStack(picked));
        }
        return null;
    }
}

