/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.common.book.Book;

public class Word {
    private final Book book;
    private final GuiBook gui;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final String text;
    private final int color;
    private final String codes;
    private final List<Word> linkCluster;
    private final String tooltip;
    private final Supplier<Boolean> onClick;

    public Word(GuiBook gui, Span span, String text, int x, int y, int strWidth, List<Word> cluster) {
        this.book = gui.book;
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.width = strWidth;
        this.height = 8;
        this.text = text;
        this.color = span.color;
        this.codes = span.codes;
        this.onClick = span.onClick;
        this.linkCluster = cluster;
        this.tooltip = span.tooltip;
    }

    public void render(FontRenderer font, int mouseX, int mouseY) {
        String renderTarget = this.codes + this.text;
        int renderColor = this.color;
        if (this.isClusterHovered(mouseX, mouseY)) {
            if (this.onClick != null) {
                renderColor = this.book.linkHoverColor;
            }
            if (!this.tooltip.isEmpty()) {
                this.gui.setTooltip(this.tooltip);
            }
        }
        font.func_211126_b(renderTarget, (float)this.x, (float)this.y, renderColor);
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (this.onClick != null && mouseButton == 0 && this.isHovered(mouseX, mouseY)) {
            return this.onClick.get();
        }
        return false;
    }

    private boolean isHovered(double mouseX, double mouseY) {
        return this.gui.isMouseInRelativeRange(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    private boolean isClusterHovered(double mouseX, double mouseY) {
        if (this.linkCluster == null) {
            return this.isHovered(mouseX, mouseY);
        }
        for (Word w : this.linkCluster) {
            if (!w.isHovered(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }
}

