/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.book.template.TemplateInclusion;
import vazkii.patchouli.common.util.EntityUtil;
import vazkii.patchouli.common.util.ItemStackUtil;

public class VariableAssigner {
    private static final Pattern INLINE_VAR_PATTERN = Pattern.compile("([^#]*)(#[^#]+)#(.*)");
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("(.+)->(.+)");
    private static final Map<Class<?>, Assigner> ASSIGNERS = new HashMap();
    private static final Map<String, Function<String, String>> FUNCTIONS;

    public static void assignVariableHolders(Object object, IVariableProvider<String> variables, IComponentProcessor processor, TemplateInclusion encapsulation) {
        VariableAssigner.assignVariableHolders(new Context(object, variables, processor, encapsulation));
    }

    public static void assignVariableHolders(Context context) {
        Field[] fields;
        Class<?> clazz = context.object.getClass();
        for (Field f : fields = clazz.getFields()) {
            if (f.getAnnotation(VariableHolder.class) == null) continue;
            VariableAssigner.assignField(f, context);
        }
    }

    private static void assignField(Field f, Context c) {
        Class<?> type = f.getType();
        f.setAccessible(true);
        try {
            if (ASSIGNERS.containsKey(type)) {
                ASSIGNERS.get(type).assign(f, c);
            } else if (c.object != null) {
                Object o = f.get(c.object);
                VariableAssigner.assignVariableHolders(c.rewrap(o));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error assigning variables to component", e);
        }
    }

    private static void assignStringField(Field f, Context c) throws IllegalAccessException {
        String s = (String)f.get(c.object);
        String res = VariableAssigner.resolveString(s, c);
        if (res != null) {
            f.set(c.object, res);
        }
    }

    private static void assignStringArrayField(Field f, Context c) throws IllegalAccessException {
        String[] arr = (String[])f.get(c.object);
        for (int i = 0; i < arr.length; ++i) {
            String s = arr[i];
            String res = VariableAssigner.resolveString(s, c);
            if (res == null) continue;
            arr[i] = res;
        }
    }

    private static void assignList(Field f, Context c) throws IllegalAccessException {
        List list = (List)f.get(c.object);
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!(o instanceof String)) continue;
            String res = VariableAssigner.resolveString((String)o, c);
            list.set(i, res);
        }
    }

    private static void assignMap(Field f, Context c) throws IllegalAccessException {
        Map map = (Map)f.get(c.object);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Object v = entry.getValue();
            if (!(v instanceof String)) continue;
            Object k = entry.getKey();
            String res = VariableAssigner.resolveString((String)v, c);
            if (res == null) continue;
            entry.setValue(res);
        }
    }

    private static String resolveString(String curr, Context c) {
        if (curr == null || curr.isEmpty()) {
            return null;
        }
        String s = curr;
        Matcher m = INLINE_VAR_PATTERN.matcher(s);
        while (m.matches()) {
            String before = m.group(1);
            String var = m.group(2);
            String after = m.group(3);
            String resolved = VariableAssigner.resolveStringFunctions(var, c);
            s = String.format("%s%s%s", before, resolved, after);
            m = INLINE_VAR_PATTERN.matcher(s);
        }
        return VariableAssigner.resolveStringFunctions(s, c);
    }

    private static String resolveStringFunctions(String curr, Context c) {
        String cached = c.getCached(curr);
        if (cached != null) {
            return cached;
        }
        Matcher m = FUNCTION_PATTERN.matcher(curr);
        if (m.matches()) {
            String funcStr = m.group(2);
            String arg = m.group(1);
            if (FUNCTIONS.containsKey(funcStr)) {
                Function<String, String> func = FUNCTIONS.get(funcStr);
                String parsedArg = VariableAssigner.resolveStringFunctions(arg, c);
                return func.apply(parsedArg);
            }
            throw new IllegalArgumentException("Invalid Function " + funcStr);
        }
        String ret = VariableAssigner.resolveStringVar(curr, c);
        c.cache(curr, ret);
        return ret;
    }

    private static String resolveStringVar(String curr, Context c) {
        String original = curr;
        if (curr != null && !curr.isEmpty() && c.encapsulation != null) {
            curr = c.encapsulation.transform(curr, true);
        }
        if (curr != null) {
            String val = curr;
            if (curr.startsWith("#")) {
                val = null;
                String key = curr.substring(1);
                String originalKey = original.substring(1);
                if (c.processor != null) {
                    val = c.processor.process(originalKey);
                }
                if (val == null && c.variables.has(key)) {
                    val = c.variables.get(key);
                }
                if (val == null) {
                    val = "";
                }
            }
            c.cache(original, val);
            return val;
        }
        return curr;
    }

    private static String iname(String arg) {
        ItemStack stack = ItemStackUtil.loadStackFromString(arg);
        return stack.func_200301_q().func_150254_d();
    }

    private static String icount(String arg) {
        ItemStack stack = ItemStackUtil.loadStackFromString(arg);
        return Integer.toString(stack.func_190916_E());
    }

    private static String ename(String arg) {
        return EntityUtil.getEntityName(arg);
    }

    private static String exists(String arg) {
        return arg.isEmpty() ? "false" : "true";
    }

    private static String iexists(String arg) {
        if (arg.isEmpty()) {
            return "false";
        }
        ItemStack stack = ItemStackUtil.loadStackFromString(arg);
        if (stack.func_190926_b()) {
            return "false";
        }
        return "true";
    }

    private static String inv(String arg) {
        return arg.equalsIgnoreCase("false") ? "true" : "false";
    }

    static {
        ASSIGNERS.put(String.class, VariableAssigner::assignStringField);
        ASSIGNERS.put(String[].class, VariableAssigner::assignStringArrayField);
        ASSIGNERS.put(List.class, VariableAssigner::assignList);
        ASSIGNERS.put(Map.class, VariableAssigner::assignMap);
        FUNCTIONS = new HashMap<String, Function<String, String>>();
        FUNCTIONS.put("iname", VariableAssigner::iname);
        FUNCTIONS.put("icount", VariableAssigner::icount);
        FUNCTIONS.put("ename", VariableAssigner::ename);
        FUNCTIONS.put("lower", String::toLowerCase);
        FUNCTIONS.put("upper", String::toUpperCase);
        FUNCTIONS.put("trim", String::trim);
        FUNCTIONS.put("capital", WordUtils::capitalize);
        FUNCTIONS.put("fcapital", WordUtils::capitalizeFully);
        FUNCTIONS.put("exists", VariableAssigner::exists);
        FUNCTIONS.put("iexists", VariableAssigner::iexists);
        FUNCTIONS.put("inv", VariableAssigner::inv);
        FUNCTIONS.put("i18n", x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0]));
    }

    private static interface Assigner {
        public void assign(Field var1, Context var2) throws IllegalAccessException;
    }

    private static class Context {
        final Object object;
        final IVariableProvider<String> variables;
        final IComponentProcessor processor;
        final TemplateInclusion encapsulation;
        final Map<String, String> cachedVars;

        Context(Object object, IVariableProvider<String> variables, IComponentProcessor processor, TemplateInclusion encapsulation) {
            this(object, variables, processor, encapsulation, new HashMap<String, String>());
        }

        Context(Object object, IVariableProvider<String> variables, IComponentProcessor processor, TemplateInclusion encapsulation, Map<String, String> cachedVars) {
            this.object = object;
            this.variables = variables;
            this.processor = processor;
            this.encapsulation = encapsulation;
            this.cachedVars = cachedVars;
        }

        String getCached(String s) {
            return this.cachedVars.get(s);
        }

        void cache(String k, String v) {
            this.cachedVars.put(k, v);
        }

        Context rewrap(Object object) {
            return new Context(object, this.variables, this.processor, this.encapsulation, this.cachedVars);
        }
    }
}

