/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public class PageMultiblock
extends PageWithText {
    String name;
    @SerializedName(value="multiblock_id")
    String multiblockId;
    @SerializedName(value="multiblock")
    SerializedMultiblock serializedMultiblock;
    @SerializedName(value="enable_visualize")
    boolean showVisualizeButton = true;
    private transient AbstractMultiblock multiblockObj;
    private transient Button visualizeButton;
    private final transient Random random = new Random();
    private final transient Set<TileEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void build(BookEntry entry, int pageNum) {
        IMultiblock mb;
        if (this.multiblockId != null && !this.multiblockId.isEmpty() && (mb = MultiblockRegistry.MULTIBLOCKS.get(new ResourceLocation(this.multiblockId))) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null && this.serializedMultiblock != null) {
            this.multiblockObj = this.serializedMultiblock.toMultiblock();
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.showVisualizeButton) {
            this.visualizeButton = new GuiButtonBookEye(parent, 12, 97, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        GlStateManager.enableBlend();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock();
        }
        super.render(mouseX, mouseY, pticks);
    }

    public void handleButtonVisualize(Button button) {
        String entryKey = this.parent.getEntry().getId().toString();
        PersistentData.DataHolder.BookData.Bookmark bookmark = new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.pageNum / 2);
        MultiblockVisualizationHandler.setMultiblock(this.multiblockObj, this.name, bookmark, true);
        this.parent.addBookmarkButtons();
        if (!PersistentData.data.clickedVisualize) {
            PersistentData.data.clickedVisualize = true;
            PersistentData.save();
        }
    }

    private void renderMultiblock() {
        Vec3i size = this.multiblockObj.getSize();
        int sizeX = size.func_177958_n();
        int sizeY = size.func_177956_o();
        int sizeZ = size.func_177952_p();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)xPos, (float)yPos, (float)100.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        GlStateManager.translatef((float)(-((float)sizeX) / 2.0f), (float)(-((float)sizeY) / 2.0f), (float)0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.setIdentity();
        GlStateManager.rotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        rotMat.rotX((float)Math.toRadians(30.0));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!Screen.hasShiftDown()) {
            time += ClientTicker.partialTicks;
        }
        GlStateManager.translatef((float)(-offX), (float)0.0f, (float)(-offZ));
        GlStateManager.rotatef((float)time, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.rotY((float)Math.toRadians(-time));
        GlStateManager.rotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.rotY((float)Math.toRadians(-45.0));
        GlStateManager.translatef((float)offX, (float)0.0f, (float)offZ);
        rotMat.transform((Tuple4f)eye);
        this.renderElements(this.multiblockObj, BlockPos.func_218278_a((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        GlStateManager.popMatrix();
    }

    private void renderElements(AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
        TileEntityRendererDispatcher.field_147554_b = eye.x;
        TileEntityRendererDispatcher.field_147555_c = eye.y;
        TileEntityRendererDispatcher.field_147552_d = eye.z;
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                this.doTileEntityRenderPass(mb, blocks, 0);
            }
            this.doWorldRenderPass(mb, blocks, layer, eye);
            if (layer != BlockRenderLayer.TRANSLUCENT) continue;
            this.doTileEntityRenderPass(mb, blocks, 1);
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        this.setGlStateForPass(0);
        this.mc.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.popMatrix();
    }

    private void doWorldRenderPass(AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, @Nonnull BlockRenderLayer layer, Vector4f eye) {
        this.mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.mc.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        this.setGlStateForPass(layer);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos blockPos : blocks) {
            BlockState bs = mb.func_180495_p(blockPos);
            Block block = bs.func_177230_c();
            if (!block.canRenderInLayer(bs, layer)) continue;
            this.renderBlock(bs, blockPos, mb, Tessellator.func_178181_a().func_178180_c());
        }
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            wr.func_181674_a(eye.x, eye.y, eye.z);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderBlock(@Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull AbstractMultiblock mb, @Nonnull BufferBuilder bufferBuilder) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
            BlockRenderType type = state.func_185901_i();
            if (type != BlockRenderType.MODEL) {
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            blockrendererdispatcher.func_175019_b().renderModel((IEnviromentBlockReader)mb, ibakedmodel, state, pos, bufferBuilder, false, this.random, state.func_209533_a(pos), (IModelData)EmptyModelData.INSTANCE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doTileEntityRenderPass(AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, int pass) {
        mb.setWorld((World)this.mc.field_71441_e);
        RenderHelper.func_74519_b();
        GlStateManager.enableLighting();
        this.setGlStateForPass(1);
        for (BlockPos blockPos : blocks) {
            TileEntity te = mb.func_175625_s(blockPos);
            BlockPos relPos = new BlockPos((Entity)this.mc.field_71439_g);
            if (te == null || this.erroredTiles.contains(te)) continue;
            te.func_145834_a((World)this.mc.field_71441_e);
            te.func_174878_a(relPos.func_177971_a((Vec3i)blockPos));
            try {
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), ClientTicker.partialTicks);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                Patchouli.LOGGER.error("An exception occured rendering tile entity", (Throwable)e);
            }
        }
        RenderHelper.func_74518_a();
    }

    private void setGlStateForPass(@Nonnull BlockRenderLayer layer) {
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        this.setGlStateForPass(pass);
    }

    private void setGlStateForPass(int layer) {
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == 0) {
            GlStateManager.enableDepthTest();
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
        } else {
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.depthMask((boolean)false);
        }
    }
}

